/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree.nether;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.wood.MagmaLogBlock;

public class BrimWillowFeature
extends Feature<NoneFeatureConfiguration> {
    public BrimWillowFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        int height = context.random().nextInt(4) + 8;
        if (level.getBlockState(pos.north()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.north().north()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.west()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.west().west()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.east()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.east().east()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.south()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.south().south()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.south().west()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.south().east()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.north().west()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.north().east()).getBlock() == RuBlocks.BRIMWOOD_LOG_MAGMA) {
            return false;
        }
        if (level.getBlockState(pos.below()).getBlock() != Blocks.SCULK && level.getBlockState(pos.below()).getBlock() != RuBlocks.BRIMSPROUT_NYLIUM && !level.getBlockState(pos.below()).is(BlockTags.NYLIUM) && !level.getBlockState(pos.below()).is(BlockTags.DIRT)) {
            return false;
        }
        if (level.isEmptyBlock(pos)) {
            BlockPos.MutableBlockPos placePos = pos.mutable();
            for (int i = 0; i <= height; ++i) {
                if (i == height - 3) {
                    this.placeBranches((LevelAccessor)level, (BlockPos)placePos);
                }
                if (i == height - 5) {
                    this.placeSpine((LevelAccessor)level, (BlockPos)placePos);
                }
                if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, (BlockPos)placePos)) {
                    if (level.isOutsideBuildHeight((BlockPos)placePos)) break;
                    if (i == 2) {
                        level.setBlock((BlockPos)placePos, (BlockState)RuBlocks.BRIMWOOD_LOG_MAGMA.get().defaultBlockState().setValue((Property)MagmaLogBlock.TRANSITION_BLOCK, (Comparable)Boolean.valueOf(true)), 2);
                    } else if (i < 2) {
                        level.setBlock((BlockPos)placePos, (BlockState)RuBlocks.BRIMWOOD_LOG_MAGMA.get().defaultBlockState().setValue((Property)MagmaLogBlock.TRANSITION_BLOCK, (Comparable)Boolean.valueOf(false)), 2);
                    } else if (i > 2) {
                        level.setBlock((BlockPos)placePos, (BlockState)RuBlocks.BRIMWOOD_LOG.get().defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y), 2);
                    }
                }
                if (i == height) {
                    this.placeLeavesUpsideDown((LevelAccessor)level, (BlockPos)placePos);
                }
                placePos.move(Direction.UP);
            }
            return true;
        }
        return false;
    }

    private void placeBranches(LevelAccessor level, BlockPos pos) {
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
                this.placeBrimwoodLog(level, pos.north(), Direction.Axis.Z);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().above().north())) {
                this.placeBrimwoodLog(level, pos.north().above().north(), Direction.Axis.Z);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().above().north().north())) {
                this.placeBrimwoodLog(level, pos.north().above().north().north(), Direction.Axis.Z);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().above().north().north().north())) {
                this.placeBrimwoodLog(level, pos.north().above().north().north().north(), Direction.Axis.Z);
                this.placeLeavesUpsideDown(level, pos.north().above().north().north().north());
            }
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
                this.placeBrimwoodLog(level, pos.south(), Direction.Axis.Z);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().above().south())) {
                this.placeBrimwoodLog(level, pos.south().above().south(), Direction.Axis.Z);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().above().south().south())) {
                this.placeBrimwoodLog(level, pos.south().above().south().south(), Direction.Axis.Z);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().above().south().south().south())) {
                this.placeBrimwoodLog(level, pos.south().above().south().south().south(), Direction.Axis.Z);
                this.placeLeavesUpsideDown(level, pos.south().above().south().south().south());
            }
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
                this.placeBrimwoodLog(level, pos.east(), Direction.Axis.X);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().above().east())) {
                this.placeBrimwoodLog(level, pos.east().above().east(), Direction.Axis.X);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().above().east().east())) {
                this.placeBrimwoodLog(level, pos.east().above().east().east(), Direction.Axis.X);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().above().east().east().east())) {
                this.placeBrimwoodLog(level, pos.east().above().east().east().east(), Direction.Axis.X);
                this.placeLeavesUpsideDown(level, pos.east().above().east().east().east());
            }
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
                this.placeBrimwoodLog(level, pos.west(), Direction.Axis.X);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().above().west())) {
                this.placeBrimwoodLog(level, pos.west().above().west(), Direction.Axis.X);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().above().west().west())) {
                this.placeBrimwoodLog(level, pos.west().above().west().west(), Direction.Axis.X);
            }
            if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().above().west().west().west())) {
                this.placeBrimwoodLog(level, pos.west().above().west().west().west(), Direction.Axis.X);
                this.placeLeavesUpsideDown(level, pos.west().above().west().west().west());
            }
        }
    }

    private void placeSpine(LevelAccessor level, BlockPos pos) {
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
            this.placeBrimwoodLog(level, pos.north(), Direction.Axis.Z);
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
            this.placeBrimwoodLog(level, pos.south(), Direction.Axis.Z);
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
            this.placeBrimwoodLog(level, pos.east(), Direction.Axis.X);
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
            this.placeBrimwoodLog(level, pos.west(), Direction.Axis.X);
        }
    }

    private void placeBrimwoodLog(LevelAccessor level, BlockPos pos, Direction.Axis axis) {
        if (level.isOutsideBuildHeight(pos)) {
            return;
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, (BlockState)RuBlocks.BRIMWOOD_LOG.get().defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis), 2);
        }
    }

    private void placeBrimwoodLeaves(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return;
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, (BlockState)RuBlocks.BRIMWOOD_LEAVES.get().defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    private void placeLeavesUpsideDown(LevelAccessor level, BlockPos pos) {
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            this.placeBrimwoodLeaves(level, pos);
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above())) {
            this.placeBrimwoodLeaves(level, pos.above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().north())) {
            this.placeBrimwoodLeaves(level, pos.above().north());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().north().east())) {
            this.placeBrimwoodLeaves(level, pos.above().north().east());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().north().west())) {
            this.placeBrimwoodLeaves(level, pos.above().north().west());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().south())) {
            this.placeBrimwoodLeaves(level, pos.above().south());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().south().east())) {
            this.placeBrimwoodLeaves(level, pos.above().south().east());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().south().west())) {
            this.placeBrimwoodLeaves(level, pos.above().south().west());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().east())) {
            this.placeBrimwoodLeaves(level, pos.above().east());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().west())) {
            this.placeBrimwoodLeaves(level, pos.above().west());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
            this.placeBrimwoodLeaves(level, pos.north());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().above())) {
            this.placeBrimwoodLeaves(level, pos.north().north().above());
            this.addVine(level, pos.north().north().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west())) {
            this.placeBrimwoodLeaves(level, pos.north().west());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().west().above())) {
            this.placeBrimwoodLeaves(level, pos.north().north().west().above());
            this.addVine(level, pos.north().north().west().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west().west().above())) {
            this.placeBrimwoodLeaves(level, pos.north().west().west().above());
            this.addVine(level, pos.north().west().west().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
            this.placeBrimwoodLeaves(level, pos.west());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().west().above())) {
            this.placeBrimwoodLeaves(level, pos.west().west().above());
            this.addVine(level, pos.west().west().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west())) {
            this.placeBrimwoodLeaves(level, pos.south().west());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().west().above())) {
            this.placeBrimwoodLeaves(level, pos.south().south().west().above());
            this.addVine(level, pos.south().south().west().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west().west().above())) {
            this.placeBrimwoodLeaves(level, pos.south().west().west().above());
            this.addVine(level, pos.south().west().west().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
            this.placeBrimwoodLeaves(level, pos.south());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().above())) {
            this.placeBrimwoodLeaves(level, pos.south().south().above());
            this.addVine(level, pos.south().south().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east())) {
            this.placeBrimwoodLeaves(level, pos.south().east());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().east().above())) {
            this.placeBrimwoodLeaves(level, pos.south().south().east().above());
            this.addVine(level, pos.south().south().east().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east().east().above())) {
            this.placeBrimwoodLeaves(level, pos.south().east().east().above());
            this.addVine(level, pos.south().east().east().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
            this.placeBrimwoodLeaves(level, pos.east());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().east().above())) {
            this.placeBrimwoodLeaves(level, pos.east().east().above());
            this.addVine(level, pos.east().east().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east())) {
            this.placeBrimwoodLeaves(level, pos.north().east());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().east().above())) {
            this.placeBrimwoodLeaves(level, pos.north().north().east().above());
            this.addVine(level, pos.north().north().east().above());
        }
        if (BrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east().east().above())) {
            this.placeBrimwoodLeaves(level, pos.north().east().east().above());
            this.addVine(level, pos.north().east().east().above());
        }
    }

    private void addVine(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        int size = random.nextInt(3);
        BlockPos place = pos.above();
        for (int i = 0; i <= size; ++i) {
            if (BrimWillowFeature.isAir((LevelSimulatedReader)level, place)) {
                if (i == size) {
                    if (level.isOutsideBuildHeight(place)) break;
                    level.setBlock(place, (BlockState)RuBlocks.BRIMWOOD_LEAVES.get().defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
                } else {
                    if (level.isOutsideBuildHeight(place)) break;
                    level.setBlock(place, (BlockState)RuBlocks.BRIMWOOD_LEAVES.get().defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
                }
            } else {
                if (i == 0 || level.isOutsideBuildHeight(place)) break;
                level.setBlock(place.below(), (BlockState)RuBlocks.BRIMWOOD_LEAVES.get().defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
                break;
            }
            place = place.above();
        }
    }

    public static boolean isAirBlock(BlockState state) {
        return state.is(Blocks.AIR) || state.is(Blocks.CAVE_AIR) || state.is(Blocks.VOID_AIR);
    }

    public static boolean isAir(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, BrimWillowFeature::isAirBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, BrimWillowFeature::isReplaceableBlock);
    }
}

