/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;

public class BasaltBlobFeature
extends Feature<ColumnFeatureConfiguration> {
    private static final Supplier<ImmutableList<Block>> CANNOT_PLACE_ON = Suppliers.memoize(() -> ImmutableList.of((Object)Blocks.COBBLESTONE, (Object)Blocks.COBBLESTONE_SLAB, (Object)Blocks.COBBLESTONE_STAIRS, (Object)Blocks.MOSSY_COBBLESTONE, (Object)Blocks.MOSSY_COBBLESTONE_SLAB, (Object)Blocks.MOSSY_COBBLESTONE_STAIRS, (Object)Blocks.STONE_BRICKS, (Object)Blocks.MOSSY_STONE_BRICKS, (Object)Blocks.CRACKED_STONE_BRICKS, (Object)Blocks.STONE_BRICK_SLAB, (Object)Blocks.RED_NETHER_BRICKS, (Object)Blocks.RED_NETHER_BRICK_SLAB, (Object[])new Block[]{Blocks.RED_NETHER_BRICK_STAIRS, Blocks.MOSSY_STONE_BRICK_SLAB, Blocks.STONE_BRICK_SLAB, Blocks.COAL_BLOCK, Blocks.NETHERRACK, Blocks.SOUL_SAND, Blocks.POLISHED_ANDESITE, Blocks.POLISHED_DIORITE, Blocks.POLISHED_GRANITE, Blocks.POLISHED_ANDESITE_SLAB, Blocks.POLISHED_DIORITE_SLAB, Blocks.POLISHED_GRANITE_SLAB, Blocks.POLISHED_ANDESITE_STAIRS, Blocks.POLISHED_DIORITE_STAIRS, Blocks.POLISHED_GRANITE_STAIRS, Blocks.IRON_BARS, Blocks.SOUL_SOIL, Blocks.GRAVEL, Blocks.MOSSY_STONE_BRICK_SLAB, Blocks.LAVA, Blocks.BEDROCK, Blocks.MAGMA_BLOCK, Blocks.SOUL_SAND, Blocks.NETHER_BRICKS, Blocks.NETHER_BRICK_FENCE, Blocks.NETHER_BRICK_STAIRS, Blocks.NETHER_WART, Blocks.CHEST, RuBlocks.ASH_VENT.get(), RuBlocks.DEAD_LEAVES.get()}));

    public BasaltBlobFeature(Codec<ColumnFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ColumnFeatureConfiguration> context) {
        int i = context.chunkGenerator().getSeaLevel();
        BlockPos blockpos = context.origin();
        WorldGenLevel worldgenlevel = context.level();
        RandomSource randomsource = context.random();
        ColumnFeatureConfiguration columnfeatureconfiguration = (ColumnFeatureConfiguration)context.config();
        if (!BasaltBlobFeature.canPlaceAt((LevelAccessor)worldgenlevel, i, blockpos.mutable())) {
            return false;
        }
        int j = columnfeatureconfiguration.height().sample(randomsource);
        boolean flag = randomsource.nextFloat() < 0.9f;
        int k = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockpos1 : BlockPos.randomBetweenClosed((RandomSource)randomsource, (int)l, (int)(blockpos.getX() - k), (int)blockpos.getY(), (int)(blockpos.getZ() - k), (int)(blockpos.getX() + k), (int)blockpos.getY(), (int)(blockpos.getZ() + k))) {
            int i1 = j - blockpos1.distManhattan((Vec3i)blockpos);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn((LevelAccessor)worldgenlevel, i, blockpos1, i1, columnfeatureconfiguration.reach().sample(randomsource));
        }
        return flag1;
    }

    private boolean placeColumn(LevelAccessor level, int ylevel, BlockPos pos, int k, int offset) {
        boolean flag = false;
        block0: for (BlockPos blockpos : BlockPos.betweenClosed((int)(pos.getX() - offset), (int)pos.getY(), (int)(pos.getZ() - offset), (int)(pos.getX() + offset), (int)pos.getY(), (int)(pos.getZ() + offset))) {
            int i = blockpos.distManhattan((Vec3i)pos);
            BlockPos pos1 = BasaltBlobFeature.isAirOrLavaOcean(level, ylevel, blockpos) ? BasaltBlobFeature.findSurface(level, ylevel, blockpos.mutable(), i) : BasaltBlobFeature.findAir(level, blockpos.mutable(), i);
            if (pos1 == null) continue;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos1.mutable();
            for (int j = k - i / 2; j >= 0; --j) {
                if (BasaltBlobFeature.isAirOrLavaOcean(level, ylevel, (BlockPos)blockpos$mutableblockpos)) {
                    this.setBlock((LevelWriter)level, (BlockPos)blockpos$mutableblockpos, Blocks.BASALT.defaultBlockState());
                    blockpos$mutableblockpos.move(Direction.UP);
                    flag = true;
                    continue;
                }
                if (!level.getBlockState((BlockPos)blockpos$mutableblockpos).is(Blocks.BASALT)) continue block0;
                blockpos$mutableblockpos.move(Direction.UP);
            }
        }
        return flag;
    }

    private static BlockPos findSurface(LevelAccessor level, int ylevel, BlockPos.MutableBlockPos pos, int i) {
        while (pos.getY() > level.getMinBuildHeight() + 1 && i > 0) {
            --i;
            if (BasaltBlobFeature.canPlaceAt(level, ylevel, pos)) {
                return pos;
            }
            pos.move(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor level, int ylevel, BlockPos.MutableBlockPos pos) {
        if (!BasaltBlobFeature.isAirOrLavaOcean(level, ylevel, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = level.getBlockState((BlockPos)pos.move(Direction.DOWN));
        pos.move(Direction.UP);
        return !blockstate.isAir() && !CANNOT_PLACE_ON.get().contains((Object)blockstate.getBlock());
    }

    private static BlockPos findAir(LevelAccessor level, BlockPos.MutableBlockPos pos, int i) {
        while (pos.getY() < level.getMaxBuildHeight() && i > 0) {
            --i;
            BlockState blockstate = level.getBlockState((BlockPos)pos);
            if (CANNOT_PLACE_ON.get().contains((Object)blockstate.getBlock())) {
                return null;
            }
            if (blockstate.isAir()) {
                return pos;
            }
            pos.move(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(LevelAccessor levelAccessor, int ylevel, BlockPos pos) {
        BlockState blockstate = levelAccessor.getBlockState(pos);
        return blockstate.isAir() || blockstate.is(Blocks.LAVA) || blockstate.is(RuTags.REPLACEABLE_BLOCKS) || blockstate.is(Blocks.WATER) && pos.getY() <= ylevel;
    }
}

