/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.worldgen.features.RuVegetationFeatures;
import net.regions_unexplored.registry.ConfiguredFeatureRegistry;
import net.regions_unexplored.registry.FeatureRegistry;
import net.regions_unexplored.world.level.block.other.AshBlock;
import net.regions_unexplored.world.level.block.wood.AspenLogBlock;
import net.regions_unexplored.world.level.feature.configuration.FallenTreeConfiguration;
import net.regions_unexplored.world.level.feature.configuration.LargePointedRedstoneConfiguration;
import net.regions_unexplored.world.level.feature.configuration.PointedRedstoneClusterConfiguration;
import net.regions_unexplored.world.level.feature.configuration.PointedRedstoneConfiguration;

public class RuMiscOverworldFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> DISK_CLAY = ConfiguredFeatureRegistry.createKey("disk_clay");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DISK_GRAVEL = ConfiguredFeatureRegistry.createKey("disk_gravel");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DISK_SAND = ConfiguredFeatureRegistry.createKey("disk_sand");
    public static final ResourceKey<ConfiguredFeature<?, ?>> REDWOODS_ROCK = ConfiguredFeatureRegistry.createKey("redwoods_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_LARCH_TREE = ConfiguredFeatureRegistry.createKey("fallen_larch_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_MAPLE_TREE = ConfiguredFeatureRegistry.createKey("fallen_maple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_OAK_TREE = ConfiguredFeatureRegistry.createKey("fallen_oak_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_OAK_TREE_WITH_BLOB = ConfiguredFeatureRegistry.createKey("fallen_oak_tree_with_blob");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_PINE_TREE = ConfiguredFeatureRegistry.createKey("fallen_pine_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_SNOW_PINE_TREE = ConfiguredFeatureRegistry.createKey("fallen_snow_pine_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_SILVER_BIRCH_TREE = ConfiguredFeatureRegistry.createKey("fallen_silver_birch_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POINTED_REDSTONE = ConfiguredFeatureRegistry.createKey("pointed_redstone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_POINTED_REDSTONE = ConfiguredFeatureRegistry.createKey("large_pointed_redstone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POINTED_REDSTONE_CLUSTER = ConfiguredFeatureRegistry.createKey("pointed_redstone_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_REDSTONE_LARGE = ConfiguredFeatureRegistry.createKey("ore_redstone_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PRISMARITE_CLUSTERS = ConfiguredFeatureRegistry.createKey("prismarite_clusters");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HANGING_PRISMARITE_CLUSTER = ConfiguredFeatureRegistry.createKey("hanging_prismarite_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MINERAL_POOL = ConfiguredFeatureRegistry.createKey("mineral_pool");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LAVA_FALL = ConfiguredFeatureRegistry.createKey("lava_fall");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_LAVA_DELTA = ConfiguredFeatureRegistry.createKey("overworld_lava_delta");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ASH_VENT = ConfiguredFeatureRegistry.createKey("ash_vent");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BASALT_BLOB = ConfiguredFeatureRegistry.createKey("basalt_blob");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOSS_PATCH_WITH_WATER = ConfiguredFeatureRegistry.createKey("moss_patch_with_water");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MARSH = ConfiguredFeatureRegistry.createKey("marsh");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WATER_EDGE = ConfiguredFeatureRegistry.createKey("water_edge");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ICICLE_UP = ConfiguredFeatureRegistry.createKey("icicle_up");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMOULDERING_DIRT = ConfiguredFeatureRegistry.createKey("smouldering_dirt");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MEADOW_ROCK = ConfiguredFeatureRegistry.createKey("meadow_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROCK = ConfiguredFeatureRegistry.createKey("rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_NOISE_PUMPKINS = ConfiguredFeatureRegistry.createKey("patch_noise_pumpkins");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_NOISE_ROCKS = ConfiguredFeatureRegistry.createKey("patch_noise_rocks");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_NOISE_BUSH = ConfiguredFeatureRegistry.createKey("patch_noise_bush");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter holderGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        TagMatchTest baseStoneTest = new TagMatchTest(BlockTags.BASE_STONE_OVERWORLD);
        TagMatchTest stoneOreTest = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateOreTest = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> ORE_REDSTONE_TARGET_LIST = List.of(OreConfiguration.target((RuleTest)stoneOreTest, (BlockState)Blocks.REDSTONE_ORE.defaultBlockState()), OreConfiguration.target((RuleTest)deepslateOreTest, (BlockState)Blocks.DEEPSLATE_REDSTONE_ORE.defaultBlockState()));
        List<OreConfiguration.TargetBlockState> STONE_GRASS_TARGET_LIST = List.of(OreConfiguration.target((RuleTest)stoneOreTest, (BlockState)RuBlocks.STONE_GRASS_BLOCK.get().defaultBlockState()), OreConfiguration.target((RuleTest)deepslateOreTest, (BlockState)RuBlocks.DEEPSLATE_GRASS_BLOCK.get().defaultBlockState()));
        RuMiscOverworldFeatures.register(context, DISK_CLAY, Feature.DISK, new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)Blocks.CLAY), BlockPredicate.matchesBlocks(List.of(Blocks.DIRT, RuBlocks.PEAT_DIRT.get(), RuBlocks.SILT_DIRT.get(), RuBlocks.SILT_MUD.get(), RuBlocks.PEAT_MUD.get(), Blocks.CLAY)), (IntProvider)UniformInt.of((int)2, (int)3), 1));
        RuMiscOverworldFeatures.register(context, DISK_GRAVEL, Feature.DISK, new DiskConfiguration(RuleBasedBlockStateProvider.simple((Block)Blocks.GRAVEL), BlockPredicate.matchesBlocks(List.of(Blocks.DIRT, RuBlocks.PEAT_DIRT.get(), RuBlocks.SILT_DIRT.get(), RuBlocks.SILT_MUD.get(), RuBlocks.PEAT_MUD.get(), RuBlocks.SILT_GRASS_BLOCK.get(), RuBlocks.PEAT_GRASS_BLOCK.get(), Blocks.GRASS_BLOCK)), (IntProvider)UniformInt.of((int)2, (int)5), 2));
        RuMiscOverworldFeatures.register(context, DISK_SAND, Feature.DISK, new DiskConfiguration(new RuleBasedBlockStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SAND), List.of(new RuleBasedBlockStateProvider.Rule(BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.AIR}), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SANDSTONE)))), BlockPredicate.matchesBlocks(List.of(Blocks.DIRT, RuBlocks.PEAT_DIRT.get(), RuBlocks.SILT_DIRT.get(), RuBlocks.SILT_MUD.get(), RuBlocks.PEAT_MUD.get(), RuBlocks.SILT_GRASS_BLOCK.get(), RuBlocks.PEAT_GRASS_BLOCK.get(), Blocks.GRASS_BLOCK)), (IntProvider)UniformInt.of((int)2, (int)6), 2));
        RuMiscOverworldFeatures.register(context, REDWOODS_ROCK, Feature.FOREST_ROCK, new BlockStateConfiguration(Blocks.MOSSY_COBBLESTONE.defaultBlockState()));
        RuMiscOverworldFeatures.register(context, FALLEN_LARCH_TREE, FeatureRegistry.FALLEN_BLOB_TREE.get(), new FallenTreeConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.LARCH_LOG.get().defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.LARCH_LOG.get().defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.GOLDEN_LARCH_LEAVES.get().defaultBlockState()), 5, 9, false));
        RuMiscOverworldFeatures.register(context, FALLEN_MAPLE_TREE, FeatureRegistry.FALLEN_BLOB_TREE.get(), new FallenTreeConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.MAPLE_LOG.get().defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.MAPLE_LOG.get().defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.MAPLE_LEAVES.get().defaultBlockState()), 4, 4, false));
        RuMiscOverworldFeatures.register(context, FALLEN_OAK_TREE, FeatureRegistry.FALLEN_BLOB_TREE.get(), new FallenTreeConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.OAK_LOG.defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.OAK_LOG.defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.DEAD_LEAVES.get().defaultBlockState()), 4, 4, false));
        RuMiscOverworldFeatures.register(context, FALLEN_OAK_TREE_WITH_BLOB, FeatureRegistry.FALLEN_BLOB_TREE.get(), new FallenTreeConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.OAK_LOG.defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.OAK_LOG.defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.DEAD_LEAVES.get().defaultBlockState()), 4, 4, true));
        RuMiscOverworldFeatures.register(context, FALLEN_PINE_TREE, FeatureRegistry.FALLEN_BLOB_TREE.get(), new FallenTreeConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.PINE_LOG.get().defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.PINE_LOG.get().defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.PINE_LEAVES.get().defaultBlockState()), 5, 6, false));
        RuMiscOverworldFeatures.register(context, FALLEN_SNOW_PINE_TREE, FeatureRegistry.FALLEN_SNOW_TREE.get(), new FallenTreeConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.STRIPPED_PINE_LOG.get().defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.STRIPPED_PINE_LOG.get().defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.PINE_LEAVES.get().defaultBlockState()), 5, 6, false));
        RuMiscOverworldFeatures.register(context, FALLEN_SILVER_BIRCH_TREE, FeatureRegistry.FALLEN_BLOB_TREE.get(), new FallenTreeConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)RuBlocks.SILVER_BIRCH_LOG.get().defaultBlockState().setValue((Property)AspenLogBlock.IS_BASE, (Comparable)Boolean.valueOf(true)))), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.SILVER_BIRCH_LOG.get().defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.SILVER_BIRCH_LEAVES.get().defaultBlockState()), 4, 3, false));
        RuMiscOverworldFeatures.register(context, POINTED_REDSTONE, Feature.SIMPLE_RANDOM_SELECTOR, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{PlacementUtils.inlinePlaced((Feature)FeatureRegistry.POINTED_REDSTONE.get(), (FeatureConfiguration)new PointedRedstoneConfiguration(0.5f, 0.7f, 0.5f, 0.5f), (PlacementModifier[])new PlacementModifier[]{EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))}), PlacementUtils.inlinePlaced((Feature)FeatureRegistry.POINTED_REDSTONE.get(), (FeatureConfiguration)new PointedRedstoneConfiguration(0.5f, 0.7f, 0.5f, 0.5f), (PlacementModifier[])new PlacementModifier[]{EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1))})})));
        RuMiscOverworldFeatures.register(context, LARGE_POINTED_REDSTONE, FeatureRegistry.LARGE_POINTED_REDSTONE.get(), new LargePointedRedstoneConfiguration(30, (IntProvider)UniformInt.of((int)1, (int)6), (FloatProvider)UniformFloat.of((float)0.4f, (float)2.0f), 0.33f, (FloatProvider)UniformFloat.of((float)0.3f, (float)0.9f), (FloatProvider)UniformFloat.of((float)0.4f, (float)1.0f), (FloatProvider)UniformFloat.of((float)0.0f, (float)0.3f), 4, 0.6f));
        RuMiscOverworldFeatures.register(context, POINTED_REDSTONE_CLUSTER, FeatureRegistry.POINTED_REDSTONE_CLUSTER.get(), new PointedRedstoneClusterConfiguration(12, (IntProvider)UniformInt.of((int)3, (int)6), (IntProvider)UniformInt.of((int)2, (int)8), 1, 3, (IntProvider)UniformInt.of((int)2, (int)4), (FloatProvider)UniformFloat.of((float)0.3f, (float)0.7f), (FloatProvider)ClampedNormalFloat.of((float)0.1f, (float)0.3f, (float)0.1f, (float)0.9f), 0.1f, 3, 8));
        RuMiscOverworldFeatures.register(context, ORE_REDSTONE_LARGE, Feature.ORE, new OreConfiguration(ORE_REDSTONE_TARGET_LIST, 20));
        RuMiscOverworldFeatures.register(context, PRISMARITE_CLUSTERS, Feature.RANDOM_PATCH, RuMiscOverworldFeatures.grassPatch((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)RuBlocks.LARGE_PRISMARITE_CLUSTER.get().defaultBlockState(), 1).add((Object)RuBlocks.PRISMARITE_CLUSTER.get().defaultBlockState(), 5)), 32));
        RuMiscOverworldFeatures.register(context, HANGING_PRISMARITE_CLUSTER, FeatureRegistry.HANGING_PRISMARITE.get(), FeatureConfiguration.NONE);
        RuMiscOverworldFeatures.register(context, MINERAL_POOL, Feature.WATERLOGGED_VEGETATION_PATCH, new VegetationPatchConfiguration(BlockTags.LUSH_GROUND_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.CALCITE), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(CaveFeatures.POINTED_DRIPSTONE), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)3), 0.8f, 5, 0.1f, (IntProvider)UniformInt.of((int)4, (int)7), 0.7f));
        RuMiscOverworldFeatures.register(context, LAVA_FALL, FeatureRegistry.LAVA_FALL.get(), FeatureConfiguration.NONE);
        RuMiscOverworldFeatures.register(context, OVERWORLD_LAVA_DELTA, FeatureRegistry.OVERWORLD_LAVA_DELTA.get(), new VegetationPatchConfiguration(BlockTags.LUSH_GROUND_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)RuBlocks.VOLCANIC_ASH.get().defaultBlockState().setValue((Property)AshBlock.HAS_GRAVITY, (Comparable)Boolean.valueOf(false)))), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(CaveFeatures.POINTED_DRIPSTONE), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)3), 0.8f, 5, 0.1f, (IntProvider)UniformInt.of((int)4, (int)7), 0.7f));
        RuMiscOverworldFeatures.register(context, ASH_VENT, FeatureRegistry.ASH_VENT.get(), FeatureConfiguration.NONE);
        RuMiscOverworldFeatures.register(context, BASALT_BLOB, FeatureRegistry.BASALT_BLOB.get(), new ColumnFeatureConfiguration((IntProvider)ConstantInt.of((int)1), (IntProvider)UniformInt.of((int)1, (int)4)));
        RuMiscOverworldFeatures.register(context, MOSS_PATCH_WITH_WATER, Feature.WATERLOGGED_VEGETATION_PATCH, new VegetationPatchConfiguration(BlockTags.LUSH_GROUND_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MOSS_BLOCK), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(RuVegetationFeatures.PATCH_GRASS), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.of((int)3), 0.8f, 5, 0.1f, (IntProvider)UniformInt.of((int)4, (int)7), 0.7f));
        RuMiscOverworldFeatures.register(context, MARSH, FeatureRegistry.MARSH.get(), FeatureConfiguration.NONE);
        RuMiscOverworldFeatures.register(context, WATER_EDGE, FeatureRegistry.WATER_EDGE.get(), FeatureConfiguration.NONE);
        RuMiscOverworldFeatures.register(context, ICICLE_UP, FeatureRegistry.ICICLE_UP.get(), FeatureConfiguration.NONE);
        RuMiscOverworldFeatures.register(context, SMOULDERING_DIRT, FeatureRegistry.SMOULDERING_DIRT.get(), FeatureConfiguration.NONE);
        RuMiscOverworldFeatures.register(context, MEADOW_ROCK, FeatureRegistry.MEADOW_ROCK.get(), FeatureConfiguration.NONE);
        RuMiscOverworldFeatures.register(context, ROCK, FeatureRegistry.ROCK.get(), FeatureConfiguration.NONE);
        RuMiscOverworldFeatures.register(context, PATCH_NOISE_PUMPKINS, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)Blocks.PUMPKIN.defaultBlockState(), 4).add((Object)((BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)Direction.NORTH)), 1).add((Object)((BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)Direction.SOUTH)), 1).add((Object)((BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)Direction.EAST)), 1).add((Object)((BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)Direction.WEST)), 1).add((Object)Blocks.AIR.defaultBlockState(), 75))), List.of(RuBlocks.SILT_PODZOL.get(), Blocks.SNOW_BLOCK), (int)125));
        RuMiscOverworldFeatures.register(context, PATCH_NOISE_ROCKS, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)RuBlocks.STONE_GRASS_BLOCK.get().defaultBlockState(), 1).add((Object)RuBlocks.MOSSY_STONE.get().defaultBlockState(), 1).add((Object)Blocks.STONE.defaultBlockState(), 1).add((Object)Blocks.COBBLESTONE.defaultBlockState(), 1).add((Object)Blocks.AIR.defaultBlockState(), 75))), List.of(Blocks.GRASS_BLOCK), (int)125));
        RuMiscOverworldFeatures.register(context, PATCH_NOISE_BUSH, Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((BlockState)RuBlocks.MAPLE_LEAVES.get().defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true))), 2).add((Object)((BlockState)Blocks.OAK_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true))), 2).add((Object)Blocks.AIR.defaultBlockState(), 75))), List.of(Blocks.GRASS_BLOCK), (int)125));
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider stateProvider, int i) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)i, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(stateProvider)));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.register(key, (Object)new ConfiguredFeature(feature, config));
    }
}

