/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.contraption;

import com.jesz.createdieselgenerators.CDGPartialModels;
import com.jesz.createdieselgenerators.content.pumpjack.PumpjackBearingBBlock;
import com.jesz.createdieselgenerators.content.pumpjack.PumpjackBearingBlockEntity;
import com.jesz.createdieselgenerators.content.pumpjack.PumpjackHoleBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PumpjackHeadMovementBehaviour
implements MovementBehaviour {
    BlockPos holePos;
    BlockPos headPos;

    @Nullable
    public ItemStack canBeDisabledVia(MovementContext context) {
        return null;
    }

    public boolean isActive(MovementContext context) {
        if (!(context.contraption instanceof BearingContraption)) {
            return false;
        }
        if (((BearingContraption)context.contraption).getFacing().getAxis() == Direction.Axis.Y || ((Direction)context.state.getValue((Property)PumpjackBearingBBlock.FACING)).getAxis() != ((BearingContraption)context.contraption).getFacing().getClockWise().getAxis()) {
            return false;
        }
        return context.world.getBlockEntity(context.contraption.anchor.relative(((BearingContraption)context.contraption).getFacing().getOpposite())) instanceof PumpjackBearingBlockEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        BlockPos hole = NBTHelper.readBlockPos((CompoundTag)context.data, (String)"HolePos");
        if (!(context.world.getBlockEntity(hole) instanceof PumpjackHoleBlockEntity)) {
            return;
        }
        PumpjackBearingBlockEntity bearing = null;
        BlockEntity blockEntity = context.world.getBlockEntity(context.contraption.anchor.relative(((BearingContraption)context.contraption).getFacing().getOpposite()));
        if (blockEntity instanceof PumpjackBearingBlockEntity) {
            PumpjackBearingBlockEntity be;
            bearing = be = (PumpjackBearingBlockEntity)blockEntity;
        }
        if (bearing == null) {
            return;
        }
        SuperByteBuffer cover = CachedBuffers.partial((PartialModel)CDGPartialModels.PUMPJACK_ROPE, (BlockState)context.state);
        if (((BearingContraption)context.contraption).getFacing().getOpposite().getAxis() == Direction.Axis.X) {
            double zDst = context.position.z - (double)hole.getZ() - 0.5;
            double yDst = context.position.y - (double)hole.getY() - (double)0.8f;
            float distanceFromHole = (float)Math.sqrt(zDst * zDst + yDst * yDst);
            double angle = (double)(-((ControlledContraptionEntity)context.contraption.entity).getAngle(AnimationTickHolder.getPartialTicks())) - 180.0 * Math.atan2(yDst, zDst) / Math.PI + 90.0;
            PoseStack ms = matrices.getModel();
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)cover.transform(ms)).translate(0.5, 0.5, 0.5)).rotateXDegrees((float)angle)).scale(1.0f, distanceFromHole, 1.0f)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), buffer.getBuffer(RenderType.cutoutMipped()));
            return;
        }
        double xDst = context.position.x - (double)hole.getX() - 0.5;
        double yDst = context.position.y - (double)hole.getY() - (double)0.8f;
        float distanceFromHole = (float)Math.sqrt(xDst * xDst + yDst * yDst);
        double angle = (double)(-((ControlledContraptionEntity)context.contraption.entity).getAngle(AnimationTickHolder.getPartialTicks())) + 180.0 * Math.atan2(yDst, xDst) / Math.PI - 90.0;
        PoseStack ms = matrices.getModel();
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)cover.transform(ms)).translate(0.5, 0.5, 0.5)).rotateZDegrees((float)angle)).scale(1.0f, distanceFromHole, 1.0f)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), buffer.getBuffer(RenderType.cutoutMipped()));
    }

    public void tick(MovementContext context) {
        super.tick(context);
        PumpjackBearingBlockEntity bearing = null;
        BlockEntity blockEntity = context.world.getBlockEntity(context.contraption.anchor.relative(((BearingContraption)context.contraption).getFacing().getOpposite()));
        if (blockEntity instanceof PumpjackBearingBlockEntity) {
            PumpjackBearingBlockEntity be;
            bearing = be = (PumpjackBearingBlockEntity)blockEntity;
        }
        if (bearing == null) {
            return;
        }
        this.holePos = this.headPos = new BlockPos(context.contraption.anchor.getX() + context.localPos.getX(), context.contraption.anchor.getY() + context.localPos.getY(), context.contraption.anchor.getZ() + context.localPos.getZ());
        for (int i = 0; i < 32; ++i) {
            BlockEntity blockEntity2 = context.world.getBlockEntity(this.holePos);
            if (blockEntity2 instanceof PumpjackHoleBlockEntity) {
                PumpjackHoleBlockEntity phbe = (PumpjackHoleBlockEntity)blockEntity2;
                break;
            }
            this.holePos = this.holePos.below();
        }
        if ((blockEntity = context.world.getBlockEntity(this.holePos)) instanceof PumpjackHoleBlockEntity) {
            PumpjackHoleBlockEntity holeBE = (PumpjackHoleBlockEntity)blockEntity;
            if (bearing.crankSpeed >= 8.0f) {
                holeBE.headPos = ((Direction)bearing.getBlockState().getValue((Property)BlockStateProperties.FACING)).getAxis() == Direction.Axis.X ? context.localPos.getZ() : context.localPos.getX();
                int n = holeBE.bearingPos = ((Direction)bearing.getBlockState().getValue((Property)BlockStateProperties.FACING)).getAxis() == Direction.Axis.X ? bearing.bearingBPos.getZ() : bearing.bearingBPos.getX();
                if ((bearing.crankAngle + 270.0f) % 360.0f < (context.data.getFloat("OldCrankAngle") + 270.0f) % 360.0f) {
                    holeBE.pumpjackRotation(bearing.isLarge);
                }
            }
        }
        context.data.putFloat("OldCrankAngle", bearing.crankAngle);
        context.data.put("HolePos", NbtUtils.writeBlockPos((BlockPos)this.holePos));
    }
}

