/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.CDGDataComponents;
import com.jesz.createdieselgenerators.content.entity_filter.EntityAttribute;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilterItem;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.logistics.filter.AbstractFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterWhitelistMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class EntityFilterMenu
extends AbstractFilterMenu {
    public AttributeFilterWhitelistMode whitelistMode;
    List<EntityAttribute.EntityAttributeEntry> selectedAttributes;

    public EntityFilterMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    protected EntityFilterMenu(MenuType<?> type, int id, Inventory inv, ItemStack contentHolder) {
        super(type, id, inv, contentHolder);
    }

    public void appendSelectedAttribute(EntityAttribute entry, Boolean inverted) {
        this.selectedAttributes.add(new EntityAttribute.EntityAttributeEntry(entry, inverted));
    }

    protected void init(Inventory inv, ItemStack contentHolder) {
        super.init(inv, (Object)contentHolder);
        ItemStack stack = new ItemStack((ItemLike)Items.NAME_TAG);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Selected Tags").withStyle(new ChatFormatting[]{ChatFormatting.RESET, ChatFormatting.BLUE}));
        this.ghostInventory.setStackInSlot(1, stack);
    }

    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(2);
    }

    protected int getPlayerInventoryXOffset() {
        return 51;
    }

    protected int getPlayerInventoryYOffset() {
        return 107;
    }

    protected void addFilterSlots() {
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, 0, 16, 27));
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.ghostInventory, 1, 16, 62){

            public boolean mayPickup(Player playerIn) {
                return false;
            }
        });
    }

    public void clearContents() {
        this.selectedAttributes.clear();
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == 37) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public boolean canDragTo(Slot slotIn) {
        if (slotIn.index == 37) {
            return false;
        }
        return super.canDragTo(slotIn);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        if (slotIn.index == 37) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slotIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (index == 37) {
            return ItemStack.EMPTY;
        }
        if (index == 36) {
            this.ghostInventory.setStackInSlot(37, ItemStack.EMPTY);
            return ItemStack.EMPTY;
        }
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.getItem(index);
            ItemStack copy = stackToInsert.copy();
            copy.setCount(1);
            this.ghostInventory.setStackInSlot(0, copy);
        }
        return ItemStack.EMPTY;
    }

    protected void initAndReadInventory(ItemStack filterItem) {
        super.initAndReadInventory((Object)filterItem);
        this.selectedAttributes = new ArrayList<EntityAttribute.EntityAttributeEntry>();
        this.whitelistMode = (AttributeFilterWhitelistMode)filterItem.getOrDefault(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, (Object)AttributeFilterWhitelistMode.WHITELIST_DISJ);
        this.selectedAttributes = new ArrayList<EntityAttribute.EntityAttributeEntry>(EntityFilterItem.getEntries(filterItem));
    }

    protected void saveData(ItemStack filterItem) {
        filterItem.set(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, (Object)this.whitelistMode);
        ArrayList attributes = new ArrayList();
        this.selectedAttributes.forEach(at -> {
            if (at == null) {
                return;
            }
            attributes.add(at);
        });
        filterItem.set(CDGDataComponents.ENTITY_FILTER_MATCHED_ATTRIBUTES, attributes);
        if (attributes.isEmpty() && this.whitelistMode == AttributeFilterWhitelistMode.WHITELIST_DISJ) {
            filterItem.remove(CDGDataComponents.ENTITY_FILTER_MATCHED_ATTRIBUTES);
            filterItem.remove(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE);
        }
    }
}

