/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.distillation;

import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.content.distillation.DistillationTankBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import java.util.ArrayList;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class DistillationControllerItem
extends Item {
    public DistillationControllerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity pos2;
        FluidTankBlockEntity ftbe;
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (!(blockEntity instanceof FluidTankBlockEntity) || !AllBlocks.FLUID_TANK.has((ftbe = (FluidTankBlockEntity)blockEntity).getBlockState())) {
            return super.useOn(context);
        }
        ItemStack itemInHand = context.getPlayer().getItemInHand(InteractionHand.MAIN_HAND);
        BlockPos controllerPos = ftbe.getController();
        int width = ftbe.getControllerBE().getWidth();
        int height = ftbe.getControllerBE().getHeight();
        IFluidHandler tank = (IFluidHandler)context.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, ftbe.getBlockPos(), null);
        FluidStack fluidInTank = tank.getFluidInTank(0);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < width; ++z) {
                for (int x = 0; x < width && (positions.size() < itemInHand.getCount() || context.getPlayer().isCreative()); ++x) {
                    BlockPos currentPos = controllerPos.offset(x, y, z);
                    if (!ConnectivityHandler.isConnected((BlockGetter)context.getLevel(), (BlockPos)controllerPos, (BlockPos)currentPos)) continue;
                    positions.add(currentPos);
                }
            }
        }
        if (!context.getPlayer().isCreative() && width * width * height > itemInHand.getCount()) {
            Player z = context.getPlayer();
            if (z instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)z;
                sp.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"createdieselgenerators.actionbar.distillation_controller.not_enough").withStyle(ChatFormatting.RED)));
            }
            return InteractionResult.FAIL;
        }
        for (BlockPos pos2 : positions) {
            context.getLevel().setBlock(pos2, CDGBlocks.DISTILLATION_TANK.getDefaultState(), 3);
            if (!context.getLevel().isClientSide) continue;
            for (int i = 0; i < 30; ++i) {
                Vec3 offset = VecHelper.offsetRandomly((Vec3)VecHelper.getCenterOf((Vec3i)pos2), (RandomSource)context.getLevel().getRandom(), (float)0.3f);
                Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)context.getLevel().getRandom(), (float)0.1f);
                context.getLevel().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemInHand), offset.x(), offset.y(), offset.z(), motion.x(), motion.y(), motion.z());
            }
        }
        AllSoundEvents.WRENCH_ROTATE.playAt(context.getLevel(), (double)controllerPos.getX() + (double)width / 2.0, (double)controllerPos.getY() + (double)height / 2.0, (double)controllerPos.getZ() + (double)width / 2.0, 2.0f, 1.0f, false);
        if (!context.getPlayer().isCreative() && !context.getLevel().isClientSide) {
            itemInHand.shrink(positions.size());
        }
        if ((pos2 = context.getLevel().getBlockEntity(controllerPos)) instanceof DistillationTankBlockEntity) {
            DistillationTankBlockEntity be = (DistillationTankBlockEntity)pos2;
            be.updateConnectivity();
            be.updateVerticalMulti();
            be.updateTemperature();
            IFluidHandler distillerTank = (IFluidHandler)context.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, controllerPos, null);
            if (distillerTank != null) {
                distillerTank.fill(fluidInTank, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

