/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.normal;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlockEntity;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class DieselEngineBlock
extends DirectionalKineticBlock
implements SpecialBlockItemRequirement,
IBE<DieselEngineBlockEntity>,
ProperWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public DieselEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)super.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.withWater(super.getStateForPlacement(context), context);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), be -> {
            if (be.upgrade != EngineUpgrades.EMPTY && !context.getLevel().isClientSide) {
                if (!context.getPlayer().isCreative()) {
                    context.getPlayer().getInventory().placeItemBackInInventory(be.upgrade.getItem());
                }
                be.upgrade = EngineUpgrades.EMPTY;
                be.sendData();
                IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
            }
        });
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, POWERED});
        super.createBlockStateDefinition(builder);
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        this.updateWater(level, state, pos);
        return state;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean moving) {
        level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(pos))), 2);
        super.neighborChanged(state, level, pos, block, otherPos, moving);
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.hasBlockEntity()) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
                BlockEntity patt3$temp;
                BlockEntity patt2$temp;
                BlockEntity patt1$temp;
                DieselEngineBlockEntity nbe;
                BlockEntity patt0$temp = worldIn.getBlockEntity(pos.relative((Direction)state.getValue((Property)FACING)));
                if (patt0$temp instanceof DieselEngineBlockEntity && (nbe = (DieselEngineBlockEntity)patt0$temp).getBlockState().getValue((Property)FACING) == state.getValue((Property)FACING)) {
                    be.movementDirection.setValue(nbe.movementDirection.getValue());
                }
                if ((patt1$temp = worldIn.getBlockEntity(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()))) instanceof DieselEngineBlockEntity && (nbe = (DieselEngineBlockEntity)patt1$temp).getBlockState().getValue((Property)FACING) == state.getValue((Property)FACING)) {
                    be.movementDirection.setValue(nbe.movementDirection.getValue());
                }
                if ((patt2$temp = worldIn.getBlockEntity(pos.relative((Direction)state.getValue((Property)FACING)))) instanceof DieselEngineBlockEntity && (nbe = (DieselEngineBlockEntity)patt2$temp).getBlockState().getValue((Property)FACING) == ((Direction)state.getValue((Property)FACING)).getOpposite()) {
                    be.movementDirection.setValue(nbe.movementDirection.getValue() == 1 ? 0 : 1);
                }
                if ((patt3$temp = worldIn.getBlockEntity(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()))) instanceof DieselEngineBlockEntity && (nbe = (DieselEngineBlockEntity)patt3$temp).getBlockState().getValue((Property)FACING) == ((Direction)state.getValue((Property)FACING)).getOpposite()) {
                    be.movementDirection.setValue(nbe.movementDirection.getValue() == 1 ? 0 : 1);
                }
            });
        }
        super.onPlace(state, worldIn, pos, oldState, isMoving);
    }

    public Class<DieselEngineBlockEntity> getBlockEntityClass() {
        return DieselEngineBlockEntity.class;
    }

    public BlockEntityType<? extends DieselEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.DIESEL_ENGINE.get();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        EngineUpgrades upgrade2;
        for (EngineUpgrades upgrade2 : EngineUpgrades.allUpgrades) {
            if (upgrade2 == EngineUpgrades.EMPTY || !upgrade2.getItem().is(stack.getItem())) continue;
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                if (!upgrade2.canAddOn((IEngine)be)) {
                    return;
                }
                if (be.upgrade != EngineUpgrades.EMPTY) {
                    return;
                }
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                be.upgrade = upgrade2;
                IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
            });
            return ItemInteractionResult.SUCCESS;
        }
        if (!((Boolean)CDGConfig.ENGINES_FILLED_WITH_ITEMS.get()).booleanValue() || stack.isEmpty() || !((upgrade2 = level.getBlockEntity(pos)) instanceof SmartBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        SmartBlockEntity be2 = (SmartBlockEntity)upgrade2;
        IFluidHandler tank = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, be2.getBlockPos(), null);
        if (tank == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() instanceof BucketItem || stack.getItem() instanceof MilkBucketItem) {
            Fluid fluid;
            Item item = stack.getItem();
            if (item instanceof BucketItem) {
                BucketItem bi = (BucketItem)item;
                v0 = bi.content;
            } else {
                v0 = fluid = (Fluid)NeoForgeMod.MILK.get();
            }
            if (!tank.getFluidInTank(0).isEmpty()) {
                return ItemInteractionResult.FAIL;
            }
            tank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            if (!player.isCreative()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            }
            return ItemInteractionResult.SUCCESS;
        }
        IFluidHandlerItem itemTank = (IFluidHandlerItem)Capabilities.FluidHandler.ITEM.getCapability(stack, null);
        if (itemTank == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        itemTank.drain(tank.fill(itemTank.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        return ItemInteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH) {
            return Shapes.or((VoxelShape)Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0));
        }
        if (state.getValue((Property)FACING) == Direction.DOWN) {
            return Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape)Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        }
        if (state.getValue((Property)FACING) == Direction.UP) {
            return Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0));
        }
        return Shapes.or((VoxelShape)Block.box((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == face.getAxis();
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.getValue((Property)FACING)).getAxis();
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(CDGBlocks.DIESEL_ENGINE.asStack());
        if (blockEntity instanceof DieselEngineBlockEntity) {
            DieselEngineBlockEntity be = (DieselEngineBlockEntity)blockEntity;
            ItemStack upgradeItem = be.upgrade.getItem();
            if (!upgradeItem.isEmpty()) {
                list.add(upgradeItem);
            }
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, list);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                if (be.upgrade != EngineUpgrades.EMPTY) {
                    DieselEngineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)be.upgrade.getItem());
                }
            });
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

