/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.canister;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGDataComponents;
import com.jesz.createdieselgenerators.content.canister.CanisterBlockEntity;
import com.jesz.createdieselgenerators.content.canister.CanisterBlockItem;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;

public class CanisterBlock
extends Block
implements IBE<CanisterBlockEntity>,
ProperWaterloggedBlock,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty ENCHANTED = BooleanProperty.create((String)"enchanted");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public CanisterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)super.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ENCHANTED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)ENCHANTED) != false ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.withWater((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER))), context);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (level.isClientSide) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            be.setComponentPatch(stack.getComponentsPatch());
            be.setCapacityEnchantLevel(stack.getEnchantmentLevel(level.holderOrThrow(AllEnchantments.CAPACITY)));
        });
        if (stack.getEnchantmentLevel(level.holderOrThrow(AllEnchantments.CAPACITY)) != 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENCHANTED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Y) {
            return Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        }
        if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X) {
            return Block.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
        }
        return Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, ENCHANTED});
        super.createBlockStateDefinition(builder);
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return state;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        List lootDrops = super.getDrops(state, params);
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (!(object instanceof CanisterBlockEntity)) {
            return lootDrops;
        }
        CanisterBlockEntity be = (CanisterBlockEntity)((Object)object);
        FluidStack contents = be.tank.getCapability().getFluidInTank(0);
        DataComponentPatch components = be.getComponentPatch().forget(c -> c.equals(CDGDataComponents.FLUID_CONTENTS));
        if (components.isEmpty() && contents.isEmpty()) {
            return lootDrops;
        }
        return lootDrops.stream().peek(stack -> {
            if (stack.getItem() instanceof CanisterBlockItem) {
                stack.applyComponents(components);
                stack.set(CDGDataComponents.FLUID_CONTENTS, (Object)SimpleFluidContent.copyOf((FluidStack)contents));
            }
        }).toList();
    }

    public Class<CanisterBlockEntity> getBlockEntityClass() {
        return CanisterBlockEntity.class;
    }

    public BlockEntityType<? extends CanisterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.CANISTER.get();
    }
}

