/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.bulk_fermenter;

import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.bulk_fermenter.BulkFermenterBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BulkFermentingRecipe
extends StandardProcessingRecipe<RecipeInput> {
    public BulkFermentingRecipe(ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)CDGRecipes.BULK_FERMENTING, params);
    }

    protected int getMaxInputCount() {
        return 9;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(RecipeInput inventory, Level level) {
        return false;
    }

    public boolean apply(BulkFermenterBlockEntity be, boolean test) {
        IItemHandler availableItems = (IItemHandler)be.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), null);
        IFluidHandler fluidCap = (IFluidHandler)be.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), null);
        if (availableItems == null || fluidCap == null || !(fluidCap instanceof BulkFermenterBlockEntity.BulkFermenterFluidHandler)) {
            return false;
        }
        BulkFermenterBlockEntity.BulkFermenterFluidHandler availableFluids = (BulkFermenterBlockEntity.BulkFermenterFluidHandler)fluidCap;
        BlazeBurnerBlock.HeatLevel heat = be.highestHeatLevel;
        if (!this.getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(this.getIngredients());
        NonNullList fluidIngredients = this.getFluidIngredients();
        for (boolean simulate : Iterate.trueAndFalse) {
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            block1: for (Ingredient ingredient : ingredients) {
                for (int slot = 0; slot < availableItems.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItems.getStackInSlot(slot).getCount() <= extractedItemsFromSlot[slot] || !ingredient.test(extracted = availableItems.extractItem(slot, 1, true))) continue;
                    if (!simulate) {
                        availableItems.extractItem(slot, 1, false);
                    }
                    int n = slot;
                    extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            block3: for (SizedFluidIngredient fluidIngredient : fluidIngredients) {
                int amountRequired = fluidIngredient.amount();
                for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                    FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                    int drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
                    continue block3;
                }
                return false;
            }
            if (fluidsAffected) {
                be.onFluidStackChanged();
            }
            if (simulate) {
                recipeOutputItems.addAll(this.rollResults(be.getLevel().random));
                for (FluidStack fluidStack : this.getFluidResults()) {
                    if (fluidStack.isEmpty()) continue;
                    recipeOutputFluids.add(fluidStack);
                }
            }
            if (this.applyOutputs(be, recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    private boolean applyOutputs(BulkFermenterBlockEntity be, List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean test) {
        IItemHandler availableItems = (IItemHandler)be.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), null);
        IFluidHandler fluidCap = (IFluidHandler)be.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), null);
        if (availableItems == null || fluidCap == null || !(fluidCap instanceof BulkFermenterBlockEntity.BulkFermenterFluidHandler)) {
            return false;
        }
        BulkFermenterBlockEntity.BulkFermenterFluidHandler availableFluids = (BulkFermenterBlockEntity.BulkFermenterFluidHandler)fluidCap;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            items.add(availableItems.getStackInSlot(i).copy());
        }
        for (ProcessingOutput result : this.getRollableResults()) {
            ItemStack stack = result.getStack().copy();
            int left = stack.getCount();
            for (ItemStack slot : items) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)stack)) continue;
                if (availableItems.getSlotLimit(0) - slot.getCount() >= left) {
                    left = 0;
                    break;
                }
                return false;
            }
            if (left <= 0) continue;
            for (ItemStack slot : items) {
                if (!slot.isEmpty()) continue;
                left = 0;
                break;
            }
            if (left <= 0) continue;
            return false;
        }
        boolean[] emptyTanksFilled = new boolean[availableFluids.tankCount];
        for (FluidStack result : this.getFluidResults()) {
            result = result.copy();
            boolean filled = false;
            for (FluidTank tank : availableFluids.tanks) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)result)) continue;
                if (tank.fill(result, IFluidHandler.FluidAction.SIMULATE) < result.getAmount()) {
                    return false;
                }
                filled = true;
            }
            if (filled) continue;
            NonNullList<FluidTank> tanks = availableFluids.tanks;
            for (int i = 0; i < tanks.size(); ++i) {
                FluidTank tank = (FluidTank)tanks.get(i);
                if (!tank.getFluid().isEmpty() || emptyTanksFilled[i]) continue;
                if (tank.fill(result, IFluidHandler.FluidAction.SIMULATE) < result.getAmount()) {
                    return false;
                }
                emptyTanksFilled[i] = true;
            }
        }
        if (test) {
            return true;
        }
        for (ItemStack stack : outputItems) {
            stack = stack.copy();
            ItemHandlerHelper.insertItemStacked((IItemHandler)availableItems, (ItemStack)stack, (boolean)false);
        }
        for (FluidStack output : outputFluids) {
            availableFluids.fill(output.copy(), IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }
}

