/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.mixin;

import com.drmangotea.tfmg.content.decoration.tanks.aluminum.AluminumTankBlock;
import com.drmangotea.tfmg.content.decoration.tanks.cast_iron.CastIronTankBlock;
import com.drmangotea.tfmg.mixin.accessor.FluidTankBlockEntityAccessor;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidTankBlockEntity.class})
public class FluidTankBlockEntityMixin
extends SmartBlockEntity {
    @Shadow
    protected int height;
    @Shadow
    protected int width;
    @Shadow
    protected BlockPos controller;
    @Shadow
    protected boolean window;

    public FluidTankBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(at={@At(value="HEAD")}, method={"toggleWindows"}, cancellable=true, remap=false)
    public void toggleWindows(CallbackInfo ci) {
        FluidTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (be.boiler.isActive()) {
            return;
        }
        be.setWindows(((FluidTankBlockEntityAccessor)be).tfmg$getWindow());
    }

    @Inject(at={@At(value="HEAD")}, method={"notifyMultiUpdated"}, cancellable=true, remap=false)
    public void notifyMultiUpdated(CallbackInfo ci) {
        BlockState state = this.getBlockState();
        if (AluminumTankBlock.isTank(state) || CastIronTankBlock.isTank(state)) {
            state = (BlockState)state.setValue((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().getY() == this.getBlockPos().getY()));
            state = (BlockState)state.setValue((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(this.getController().getY() + this.height - 1 == this.getBlockPos().getY()));
            this.level.setBlock(this.getBlockPos(), state, 6);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"removeController"}, cancellable=true, remap=false)
    public void removeController(boolean keepFluids, CallbackInfo ci) {
        if (this.level.isClientSide) {
            return;
        }
        BlockState state = this.getBlockState();
        if (AluminumTankBlock.isTank(state) || CastIronTankBlock.isTank(state)) {
            state = (BlockState)state.setValue((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.setValue((Property)FluidTankBlock.SHAPE, (Comparable)(this.window ? FluidTankBlock.Shape.WINDOW : FluidTankBlock.Shape.PLAIN));
            this.getLevel().setBlock(this.worldPosition, state, 22);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setWindows"}, cancellable=true, remap=false)
    public void setWindows(boolean window, CallbackInfo ci) {
        if (this.getBlockState().is((Block)TFMGBlocks.ALUMINUM_FLUID_TANK.get()) || this.getBlockState().is((Block)TFMGBlocks.CAST_IRON_FLUID_TANK.get())) {
            this.window = window;
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                        BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                        BlockState blockState = this.level.getBlockState(pos);
                        if (!AluminumTankBlock.isTank(blockState) && !CastIronTankBlock.isTank(blockState)) continue;
                        FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                        if (window) {
                            if (this.width == 1) {
                                shape = FluidTankBlock.Shape.WINDOW;
                            }
                            if (this.width == 2) {
                                FluidTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                            }
                            if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                                shape = FluidTankBlock.Shape.WINDOW;
                            }
                        }
                        this.level.setBlock(pos, (BlockState)blockState.setValue((Property)FluidTankBlock.SHAPE, (Comparable)shape), 22);
                        this.level.getChunkSource().getLightEngine().checkBlock(pos);
                    }
                }
            }
            return;
        }
    }

    @Shadow
    public FluidTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return (FluidTankBlockEntity)this.level.getBlockEntity(this.getBlockPos());
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof FluidTankBlockEntity) {
            return (FluidTankBlockEntity)blockEntity;
        }
        return null;
    }

    @Shadow
    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    @Shadow
    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    @Shadow
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.STEAM_ENGINE_MAXED, AllAdvancements.PIPE_ORGAN});
    }
}

