/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.base;

import com.drmangotea.tfmg.content.machinery.vat.base.VatBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.fluids.FluidStack;

public class VatRenderer
extends SafeBlockEntityRenderer<VatBlockEntity> {
    public VatRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(VatBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        float fluidLevel = this.renderFluids(be, partialTicks, ms, bufferSource, light, overlay);
    }

    protected float renderFluids(VatBlockEntity vat, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float tankHullWidth;
        SmartFluidTankBehaviour inputFluids = (SmartFluidTankBehaviour)vat.getBehaviour(SmartFluidTankBehaviour.INPUT);
        SmartFluidTankBehaviour outputFluids = (SmartFluidTankBehaviour)vat.getBehaviour(SmartFluidTankBehaviour.OUTPUT);
        SmartFluidTankBehaviour[] tanks = new SmartFluidTankBehaviour[]{inputFluids, outputFluids};
        float totalUnits = vat.getTotalFluidUnits(partialTicks);
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        float fluidLevel = Mth.clamp((float)(totalUnits / (float)vat.getTotalCapacity()), (float)0.0f, (float)1.0f);
        fluidLevel = 1.0f - (1.0f - fluidLevel) * (1.0f - fluidLevel);
        float capHeight = 0.25f;
        float xMin = tankHullWidth = 0.0703125f;
        float xMax = xMin + (float)vat.width - 2.0f * tankHullWidth;
        float zMin = tankHullWidth;
        float zMax = zMin + (float)vat.width - 2.0f * tankHullWidth;
        float level = 0.0f;
        for (SmartFluidTankBehaviour behaviour : tanks) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                FluidStack renderedFluid = tankSegment.getRenderedFluid();
                if (renderedFluid.isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                float yMin = capHeight + level;
                float yMax = yMin + fluidLevel * ((float)vat.height - 2.0f * capHeight) / 5.0f;
                NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)renderedFluid, xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, false);
                level += yMax - yMin;
            }
        }
        return level;
    }

    public boolean shouldRenderOffScreen(VatBlockEntity te) {
        return te.isController();
    }
}

