/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types.regular_engine;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.engines.base.EngineProperties;
import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.types.regular_engine.PistonPosition;
import com.drmangotea.tfmg.content.engines.types.regular_engine.RegularEngineBlock;
import com.drmangotea.tfmg.content.engines.types.turbine_engine.TurbineEngineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGSoundEvents;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RegularEngineBlockEntity
extends AbstractSmallEngineBlockEntity {
    public EngineType type = this.getDefaultEngineType();
    public SmartInventory pistonInventory;
    List<TagKey<Fluid>> supportedFuels = new ArrayList<TagKey<Fluid>>();
    protected int soundTimer = 0;
    boolean updateFuel = true;

    public RegularEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.pistonInventory = this.createInventory();
    }

    public EngineType getDefaultEngineType() {
        return EngineType.I;
    }

    public void updateInventory() {
        this.pistonInventory = this.createInventory();
    }

    public SmartInventory createInventory() {
        return new SmartInventory(this.type.pistons.size(), (SyncedBlockEntity)this).withMaxStackSize(1).whenContentsChanged(this::onInventoryChanged);
    }

    private void onInventoryChanged(int integer) {
        this.refreshFuels();
        this.updateRotation();
        this.sendData();
        this.setChanged();
    }

    public void refreshFuels() {
        CompoundTag fuelsToAllow = (CompoundTag)this.pistonInventory.getItem(0).get(TFMGDataComponents.FUEL_TAGS);
        if (fuelsToAllow == null) {
            return;
        }
        ArrayList<TagKey> fuelsFound = new ArrayList<TagKey>();
        for (String key : fuelsToAllow.getAllKeys()) {
            String id = fuelsToAllow.getString(key);
            TagKey tag = FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)id.replace("c:", "")));
            fuelsFound.add(tag);
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity;
            be.supportedFuels = new ArrayList<TagKey<Fluid>>(fuelsFound);
            for (Long position : be.engines) {
                BlockPos pos = BlockPos.of((long)position);
                BlockEntity blockEntity2 = this.level.getBlockEntity(pos);
                if (!(blockEntity2 instanceof RegularEngineBlockEntity)) continue;
                RegularEngineBlockEntity be1 = (RegularEngineBlockEntity)blockEntity2;
                be1.supportedFuels = new ArrayList<TagKey<Fluid>>(fuelsFound);
            }
        }
    }

    @Override
    public List<TagKey<Fluid>> getSupportedFuels() {
        return this.supportedFuels;
    }

    @Override
    public boolean canWork() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity controller = (RegularEngineBlockEntity)blockEntity;
            for (Long position : controller.getAllEngines()) {
                BlockEntity blockEntity2 = this.level.getBlockEntity(BlockPos.of((long)position));
                if (!(blockEntity2 instanceof RegularEngineBlockEntity)) continue;
                RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity2;
                for (int i = 0; i < be.pistonInventory.getSlots(); ++i) {
                    if (!be.pistonInventory.getItem(i).isEmpty()) continue;
                    return false;
                }
            }
            return super.canWork();
        }
        return false;
    }

    public boolean hasAllPistons() {
        for (Long position : this.getControllerBE().getAllEngines()) {
            BlockEntity blockEntity = this.level.getBlockEntity(BlockPos.of((long)position));
            if (!(blockEntity instanceof RegularEngineBlockEntity)) continue;
            RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity;
            for (int i = 0; i < be.pistonInventory.getSlots(); ++i) {
                if (!be.pistonInventory.getItem(i).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean insertItem(ItemStack itemStack, boolean shifting, Player player, InteractionHand hand) {
        BlockEntity blockEntity;
        int i;
        if (itemStack.is((Item)AllItems.EMPTY_SCHEMATIC.get())) {
            if (this.type == EngineType.RADIAL || this.type == EngineType.TURBINE) {
                return false;
            }
            boolean next = false;
            if (this.type == EngineType.BOXER) {
                BlockEntity blockEntity2 = this.level.getBlockEntity(this.controller);
                if (blockEntity2 instanceof RegularEngineBlockEntity) {
                    RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity2;
                    be.updateEngineType(EngineType.I);
                }
                AllSoundEvents.CONFIRM.play(this.level, null, (Vec3i)this.getBlockPos(), 1.0f, 1.0f);
                return true;
            }
            for (EngineType engineType : EngineType.values()) {
                if (next) {
                    BlockEntity blockEntity3 = this.level.getBlockEntity(this.controller);
                    if (blockEntity3 instanceof RegularEngineBlockEntity) {
                        RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity3;
                        be.updateEngineType(engineType);
                    }
                    AllSoundEvents.CONFIRM.play(this.level, null, (Vec3i)this.getBlockPos(), 1.0f, 1.0f);
                    return true;
                }
                if (engineType != this.type) continue;
                next = true;
            }
        }
        if (itemStack.is((Item)TFMGItems.SCREWDRIVER.get())) {
            if (!this.pistonInventory.isEmpty()) {
                for (i = 0; i < this.pistonInventory.getSlots(); ++i) {
                    if (this.pistonInventory.getItem(i).isEmpty()) continue;
                    this.dropItem(this.pistonInventory.getItem(i));
                    this.pistonInventory.setItem(i, ItemStack.EMPTY);
                    this.playRemovalSound();
                    this.updateRotation();
                    this.setChanged();
                    this.sendData();
                    return true;
                }
            }
            for (i = this.componentsInventory.components.size() - 1; i >= 0; --i) {
                if (this.componentsInventory.getItem(i).isEmpty()) continue;
                this.dropItem(this.componentsInventory.getItem(i));
                this.componentsInventory.setItem(i, ItemStack.EMPTY);
                this.playRemovalSound();
                this.updateRotation();
                this.setChanged();
                this.sendData();
                return true;
            }
        }
        if (this.hasAllComponents() && this.isCorrectCylinder(itemStack) && this.isCylinderSame(itemStack)) {
            for (i = this.pistonInventory.getSlots() - 1; i >= 0; --i) {
                if (!this.pistonInventory.getItem(i).isEmpty()) continue;
                ItemStack toInsert = itemStack.copy();
                toInsert.setCount(1);
                this.pistonInventory.setItem(i, toInsert);
                itemStack.shrink(1);
                this.playInsertionSound();
                this.updateRotation();
                this.setChanged();
                this.sendData();
                return true;
            }
        }
        if (this.nextComponent().test(itemStack) && !this.isController() && (blockEntity = this.level.getBlockEntity(this.controller)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            return be.insertItem(itemStack, shifting, player, hand);
        }
        return super.insertItem(itemStack, shifting, player, hand);
    }

    public boolean isCorrectCylinder(ItemStack itemStack) {
        return itemStack.is((Item)TFMGItems.ENGINE_CYLINDER.get()) || itemStack.is((Item)TFMGItems.SIMPLE_ENGINE_CYLINDER.get()) || itemStack.is((Item)TFMGItems.DIESEL_ENGINE_CYLINDER.get());
    }

    public boolean isCylinderSame(ItemStack stack) {
        if (stack.is((Item)TFMGItems.TURBINE_BLADE.get())) {
            return true;
        }
        CompoundTag tag = (CompoundTag)stack.get(TFMGDataComponents.FUELS);
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity controller = (RegularEngineBlockEntity)blockEntity;
            ArrayList<Long> engines = new ArrayList<Long>(controller.engines);
            engines.add(this.controller.asLong());
            for (int i = 0; i < controller.engineLength() + 1; ++i) {
                BlockPos pos = BlockPos.of((long)((Long)engines.get(i)));
                BlockEntity blockEntity2 = this.level.getBlockEntity(pos);
                if (!(blockEntity2 instanceof RegularEngineBlockEntity)) continue;
                RegularEngineBlockEntity be = (RegularEngineBlockEntity)blockEntity2;
                for (int y = 0; y < be.pistonInventory.getSlots(); ++y) {
                    CompoundTag tagInside;
                    if (!be.pistonInventory.getItem(y).is((Item)TFMGItems.ENGINE_CYLINDER.get()) || (tagInside = (CompoundTag)be.pistonInventory.getItem(y).get(TFMGDataComponents.FUELS)).toString().equals(tag.toString())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.makeSound();
        }
        if (this.updateFuel) {
            this.refreshFuels();
            this.updateFuel = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void makeSound() {
        ++this.soundTimer;
        if (!this.isController()) {
            return;
        }
        if ((double)this.soundTimer > 1.0 / Math.min(6000.0, (double)this.rpm * 2.0E-4 * (double)this.pistonInventory.getSlots())) {
            this.soundTimer = 0;
            float randomPitch = (this.level.getRandom().nextFloat() - 0.5f) * 0.05f;
            if (this instanceof TurbineEngineBlockEntity) {
                TFMGSoundEvents.ENGINE.playAt(this.level, (Vec3i)this.worldPosition, 0.06f * TFMGConfigs.common().machines.engineLoudness.getF(), 1.5f, false);
            } else {
                TFMGSoundEvents.ENGINE.playAt(this.level, (Vec3i)this.worldPosition, 0.1f * TFMGConfigs.common().machines.engineLoudness.getF(), 0.7f + randomPitch, false);
            }
        }
    }

    public boolean updateEngineType(EngineType newType) {
        RegularEngineBlockEntity be;
        BlockEntity blockEntity;
        BlockPos pos;
        int i;
        Direction updateDirection = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockEntity blockEntity2 = this.level.getBlockEntity(this.getBlockPos().relative(updateDirection));
        if (blockEntity2 instanceof RegularEngineBlockEntity) {
            RegularEngineBlockEntity be2 = (RegularEngineBlockEntity)blockEntity2;
            return be2.updateEngineType(newType);
        }
        for (i = 0; i <= this.engineLength(); ++i) {
            pos = this.getBlockPos().relative(updateDirection.getOpposite(), i);
            blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof RegularEngineBlockEntity)) continue;
            be = (RegularEngineBlockEntity)blockEntity;
            if (be.pistonInventory.isEmpty()) continue;
            return false;
        }
        for (i = 0; i <= this.engineLength(); ++i) {
            pos = this.getBlockPos().relative(updateDirection.getOpposite(), i);
            blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof RegularEngineBlockEntity)) continue;
            be = (RegularEngineBlockEntity)blockEntity;
            be.type = newType;
            be.updateInventory();
            this.level.setBlockAndUpdate(pos, (BlockState)be.getBlockState().setValue((Property)RegularEngineBlock.EXTENDED, (Comparable)Boolean.valueOf(newType == EngineType.I || newType == EngineType.U)));
        }
        return true;
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putString("Type", this.type.name);
        compound.put("Cylinders", (Tag)this.pistonInventory.serializeNBT(registries));
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        for (EngineType engineType : EngineType.values()) {
            if (!engineType.name.matches(compound.getString("Type"))) continue;
            this.type = engineType;
            break;
        }
        this.pistonInventory.deserializeNBT(registries, compound.getCompound("Cylinders"));
    }

    @Override
    public float efficiencyModifier() {
        return this.type.effeciencyModifier * this.getFuelType().getEfficiency() * this.getUpgradeEfficiencyModifier();
    }

    @Override
    public float speedModifier() {
        return this.type.speedModifier * this.getFuelType().getSpeed() * this.getUpgradeSpeedModifier();
    }

    @Override
    public float torqueModifier() {
        return this.type.torqueModifier * this.getFuelType().getStress() * this.getUpgradeTorqueModifier();
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.isController()) {
            return this.getControllerBE().addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        TFMGTexts.header("engine").style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (this.nextComponent() != Ingredient.EMPTY) {
            TFMGTexts.Engine.unfinished().forGoggles(tooltip);
            TFMGTexts.Engine.nextComponent(this.nextComponent().getItems()[0]).forGoggles(tooltip);
            return true;
        }
        if (!this.hasAllPistons()) {
            TFMGTexts.Engine.lastRequirement(this instanceof TurbineEngineBlockEntity ? "turbines" : "pistons").forGoggles(tooltip);
            return true;
        }
        TFMGTexts.Engine.type(this.type.langKey).forGoggles(tooltip, 1);
        TFMGTexts.Engine.rpm(this.rpm).forGoggles(tooltip, 1);
        TFMGTexts.Engine.signal(this.highestSignal).forGoggles(tooltip, 1);
        TFMGTexts.Engine.torque(this.torque).forGoggles(tooltip, 1);
        TFMGTexts.Engine.fuelConsumption((float)this.getFuelConsumption() / 1.5f).forGoggles(tooltip, 1);
        if (this.oil > 0) {
            TFMGTexts.Engine.oil(this.oil).forGoggles(tooltip);
        }
        if (this.coolingFluid > 0) {
            TFMGTexts.Engine.coolingFluid(this.coolingFluid).forGoggles(tooltip);
        }
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        return true;
    }

    @Override
    public String engineId() {
        return this.type.name;
    }

    public static enum EngineType {
        I("engine_i", EngineProperties.pistonsI(), 1.0f, 1.0f, 1.0f, true),
        V("engine_v", EngineProperties.pistonsV(), 1.2f, 1.3f, 0.8f),
        W("engine_w", EngineProperties.pistonsW(), 1.3f, 1.1f, 0.5f),
        U("engine_u", EngineProperties.pistonsU(), 1.0f, 1.5f, 0.9f, true),
        BOXER("engine_boxer", EngineProperties.pistonsBoxer(), 1.0f, 0.8f, 1.2f),
        RADIAL("radial", EngineProperties.pistonsRadial(), 1.0f, 0.8f, 1.2f),
        TURBINE("turbine", EngineProperties.pistonsTurbine(), 1.5f, 1.5f, 0.5f);

        public final float speedModifier;
        public final float torqueModifier;
        public final float effeciencyModifier;
        public final List<PistonPosition> pistons;
        public final List<Fluid> fluidBlacklist;
        public final String name;
        public final boolean upgradesOnSide;
        public final String langKey;

        private EngineType(String name, List<PistonPosition> positions, float speedModifier, float torqueModifier, float efficiencyModifier, boolean upgradesOnSide) {
            this(name, positions, speedModifier, torqueModifier, efficiencyModifier, upgradesOnSide, new ArrayList<Fluid>());
        }

        private EngineType(String name, List<PistonPosition> positions, float speedModifier, float torqueModifier, float efficiencyModifier) {
            this(name, positions, speedModifier, torqueModifier, efficiencyModifier, false, new ArrayList<Fluid>());
        }

        private EngineType(String name, List<PistonPosition> positions, float speedModifier, float torqueModifier, float efficiencyModifier, boolean upgradesOnSide, List<Fluid> fluidBlacklist) {
            this.name = name;
            this.pistons = positions;
            this.speedModifier = speedModifier;
            this.torqueModifier = torqueModifier;
            this.effeciencyModifier = efficiencyModifier;
            this.fluidBlacklist = fluidBlacklist;
            this.upgradesOnSide = upgradesOnSide;
            this.langKey = "engine.type." + name;
        }
    }
}

