/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.storage;

import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.storage.TFMGForgeEnergyStorage;
import com.drmangotea.tfmg.content.electricity.utilities.converter.ConverterBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class AccumulatorBlockEntity
extends ElectricBlockEntity {
    public TFMGForgeEnergyStorage energy = this.createEnergyStorage(1);
    private IEnergyStorage energyCapability;
    public int length = 1;
    boolean refreshNextTick = true;
    public BlockPos controller = this.getBlockPos();
    int signal;
    boolean signalChanged;

    public AccumulatorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyCapability = this.energy;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)TFMGBlockEntities.ACCUMULATOR.get(), (be, context) -> be.energyCapability);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    public void neighbourChanged() {
        BlockEntity blockEntity;
        int power;
        if (!this.hasLevel()) {
            return;
        }
        if (this.isController() && (power = this.level.getBestNeighborSignal(this.worldPosition)) != this.signal) {
            this.signalChanged = true;
        }
        if ((blockEntity = this.level.getBlockEntity(this.controller)) instanceof AccumulatorBlockEntity) {
            AccumulatorBlockEntity be = (AccumulatorBlockEntity)blockEntity;
            int power2 = this.level.getBestNeighborSignal(this.worldPosition);
            if (power2 != be.signal) {
                be.signalChanged = true;
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.refreshController();
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.refreshController();
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity blockEntity;
        if (!this.isController() && (blockEntity = this.level.getBlockEntity(this.controller)) instanceof AccumulatorBlockEntity) {
            AccumulatorBlockEntity be = (AccumulatorBlockEntity)blockEntity;
            return be.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        }
        super.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        TFMGTexts.electricalCapacity(this.energy.getEnergyStored()).forGoggles(tooltip, 1);
        TFMGTexts.chargingRate(this.getChargingRate()).forGoggles(tooltip, 1);
        TFMGTexts.electricalMaxCapacity(this.getMaxCapacity()).forGoggles(tooltip, 1);
        return true;
    }

    public void refreshController() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING);
        for (int i = 0; i < 15; ++i) {
            AccumulatorBlockEntity otherBE;
            AccumulatorBlockEntity be;
            BlockPos pos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING), i);
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (!(blockEntity instanceof AccumulatorBlockEntity) || (be = (AccumulatorBlockEntity)blockEntity).getBlockState().getValue((Property)DirectionalBlock.FACING) != facing || (blockEntity = this.level.getBlockEntity(pos.relative(facing))) instanceof AccumulatorBlockEntity && (otherBE = (AccumulatorBlockEntity)blockEntity).getBlockState().getValue((Property)DirectionalBlock.FACING) == facing) continue;
            be.refreshMultiblock();
        }
    }

    public void refreshMultiblock() {
        AccumulatorBlockEntity be;
        Direction facing = (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING);
        this.refreshCapability();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (!(blockEntity instanceof AccumulatorBlockEntity) || (be = (AccumulatorBlockEntity)blockEntity).getBlockState().getValue((Property)DirectionalBlock.FACING) != facing) {
            AccumulatorBlockEntity otherBe;
            BlockPos pos;
            BlockEntity blockEntity2;
            int newLength = 1;
            this.controller = this.getBlockPos();
            for (int i = 1; i < 15 && (blockEntity2 = this.level.getBlockEntity(pos = this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getOpposite(), i))) instanceof AccumulatorBlockEntity && (otherBe = (AccumulatorBlockEntity)blockEntity2).getBlockState().getValue((Property)DirectionalBlock.FACING) == this.getBlockState().getValue((Property)DirectionalBlock.FACING); ++i) {
                otherBe.controller = this.getBlockPos();
                otherBe.refreshCapability();
                otherBe.length = 0;
                otherBe.energy.setEnergy(0);
                ++newLength;
            }
            this.length = newLength;
            int oldEnergy = this.energy.getEnergyStored();
            this.energy = this.createEnergyStorage(this.length);
            this.energy.setEnergy(Math.min(oldEnergy, this.energy.getMaxEnergyStored() * this.length));
            this.refreshCapability();
            this.updateNextTick();
            for (int i = 1; i < this.length; ++i) {
                BlockPos pos2 = this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getOpposite(), i);
                BlockEntity blockEntity3 = this.level.getBlockEntity(pos2);
                if (!(blockEntity3 instanceof AccumulatorBlockEntity)) continue;
                AccumulatorBlockEntity be2 = (AccumulatorBlockEntity)blockEntity3;
                be2.refreshCapability();
                be2.sendStuff();
            }
            this.sendStuff();
        }
    }

    public void refreshCapability() {
        IEnergyStorage oldCap = this.energyCapability;
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof AccumulatorBlockEntity) {
            AccumulatorBlockEntity be = (AccumulatorBlockEntity)blockEntity;
            this.energyCapability = be.energy;
        } else {
            this.energyCapability = this.energy;
        }
        this.invalidateCapabilities();
    }

    public boolean isController() {
        return this.controller == this.getBlockPos();
    }

    public TFMGForgeEnergyStorage createEnergyStorage(int multiplier) {
        return new TFMGForgeEnergyStorage(this.getMaxCapacity() * multiplier, 10000){

            @Override
            public void onEnergyChanged(int amount, int oldAmount) {
                if (oldAmount == 0 && amount > 0 || this.energy == 0) {
                    AccumulatorBlockEntity.this.updateNextTick();
                }
                AccumulatorBlockEntity.this.sendStuff();
            }
        };
    }

    public void setCapacity(ItemStack stack) {
        if (stack.get(TFMGDataComponents.ACCUMULATOR_STORAGE) != null) {
            this.energy.setEnergy((Integer)stack.get(TFMGDataComponents.ACCUMULATOR_STORAGE));
        }
    }

    protected void analogSignalChanged() {
        if (!this.isController()) {
            this.signal = this.level.getBestNeighborSignal(this.controller);
            return;
        }
        int newSignal = 0;
        for (int i = 0; i < this.length; ++i) {
            BlockPos pos = this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getOpposite(), i);
            newSignal = Math.max(newSignal, this.level.getBestNeighborSignal(pos));
        }
        this.updateNextTick();
        this.signal = newSignal;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged();
        }
        if (!this.isController()) {
            return;
        }
        if (this.refreshNextTick) {
            this.refreshMultiblock();
            this.refreshNextTick = false;
        }
        if (this.getData().getVoltage() > (Integer)TFMGConfigs.common().machines.accumulatorVoltage.get() * this.length) {
            this.energy.receiveEnergy((int)((double)this.getChargingRate() / (Double)TFMGConfigs.common().machines.FEtoWattTickConversionRate.get()), false);
            return;
        }
        if (this.canPower()) {
            int energyToExtract = this.data.networkPowerGeneration == 0 ? this.getNetworkPowerUsage() : (int)Math.max(0.0f, Math.max((float)this.powerGeneration() / (float)this.data.networkPowerGeneration * (float)this.getNetworkPowerUsage(), 0.0f));
            energyToExtract = (int)((double)energyToExtract / (Double)TFMGConfigs.common().machines.FEtoWattTickConversionRate.get());
            this.energy.extractEnergy(Math.max(energyToExtract, 1), false);
            if (this.energy.getEnergyStored() == 0) {
                this.updateNextTick();
            }
        }
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("ForgeEnergy", this.energy.getEnergyStored());
        compound.putInt("Length", this.length);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.length = compound.getInt("Length");
        this.energy.setEnergy(compound.getInt("ForgeEnergy"));
    }

    @Override
    public float resistance() {
        if (this.voltageGeneration() > 0) {
            return 0.0f;
        }
        if (!this.isController()) {
            return 0.0f;
        }
        int power = 0;
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            if (member instanceof ConverterBlockEntity || member instanceof AccumulatorBlockEntity) continue;
            power += member.getPowerUsage();
        }
        if (this.energy.getEnergyStored() == this.getMaxCapacity() || this.getData().getVoltage() <= this.getOutputVoltage() || this.canPower()) {
            return 0.0f;
        }
        if (Math.min(Math.max(this.data.networkPowerGeneration - power, 0), this.getMaxChargingRate()) == 0) {
            return 0.0f;
        }
        return (float)Math.min(Math.pow(this.data.voltage, 2.0) / (double)Math.min(Math.max(this.data.networkPowerGeneration - power, 0), this.getMaxChargingRate()), 750.0);
    }

    public boolean canPower() {
        return this.getData().networkResistance > 0 && this.getData().getVoltage() <= this.getOutputVoltage() && this.energy.getEnergyStored() > 0 && this.signal == 0;
    }

    public int getChargingRate() {
        if (this.energy.getEnergyStored() >= this.getMaxCapacity() || this.getData().getVoltage() < this.getOutputVoltage() || this.canPower() || this.data.notEnoughPower) {
            return 0;
        }
        return this.getMaxChargingRate();
    }

    @Override
    public int powerGeneration() {
        if (this.canPower()) {
            return this.getData().networkResistance > 0 ? this.maxPowerOutput() : 0;
        }
        return 0;
    }

    public int maxPowerOutput() {
        return this.getOutputVoltage() * (Integer)TFMGConfigs.common().machines.accumulatorMaxAmpOutput.get();
    }

    public int getMaxCapacity() {
        return (Integer)TFMGConfigs.common().machines.accumulatorStorage.get() * this.length;
    }

    public int getMaxChargingRate() {
        return (Integer)TFMGConfigs.common().machines.accumulatorChargingRate.get();
    }

    public int getOutputVoltage() {
        return (Integer)TFMGConfigs.common().machines.accumulatorVoltage.get() * this.length;
    }

    @Override
    public int voltageGeneration() {
        return this.canPower() ? this.getOutputVoltage() : 0;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction.getAxis() == ((Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING)).getAxis();
    }
}

