/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.compat;

import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.entity.ImmersivePaintingEntity;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingRegisterPayload;
import net.conczin.immersive_paintings.platform.Services;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class XercaPaintCompat {
    public static boolean interactWithPainting(ImmersivePaintingEntity painting, Player player, InteractionHand hand) {
        if (!Services.PLATFORM.isModLoaded("xercapaint")) {
            return false;
        }
        ItemStack stack = player.getItemInHand(hand);
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (location.getNamespace().equals("xercapaint")) {
            int w = 0;
            int h = 0;
            switch (location.getPath()) {
                case "item_canvas": {
                    w = 16;
                    h = 16;
                    break;
                }
                case "item_canvas_large": {
                    w = 32;
                    h = 32;
                    break;
                }
                case "item_canvas_long": {
                    w = 32;
                    h = 16;
                    break;
                }
                case "item_canvas_tall": {
                    w = 16;
                    h = 32;
                }
            }
            DataComponentType CANVAS_PIXELS = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"xercapaint", (String)"canvas_pixels"));
            if (CANVAS_PIXELS != null && w > 0 && stack.has(CANVAS_PIXELS)) {
                String author;
                DataComponentMap map = stack.getComponents();
                List pixels = (List)map.get(CANVAS_PIXELS);
                BufferedImage bufferedImage = new BufferedImage(w, h, 1);
                int x = 0;
                int y = 0;
                Iterator iterator = pixels.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    bufferedImage.setRGB(x, y, n);
                    if (++x < w) continue;
                    x = 0;
                    ++y;
                }
                DataComponentType CANVAS_TITLE = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"xercapaint", (String)"canvas_title"));
                DataComponentType CANVAS_AUTHOR = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"xercapaint", (String)"canvas_author"));
                Object title = map.has(CANVAS_TITLE) ? (String)stack.getComponents().get(CANVAS_TITLE) : "Unnamed Painting #" + player.getRandom().nextInt(0x100000);
                Painting p = new Painting(w / 16, h / 16, 16, (String)title, author = map.has(CANVAS_AUTHOR) ? (String)stack.getComponents().get(CANVAS_AUTHOR) : "Unknown Author", player.getUUID(), Painting.Type.XERCA, EnumSet.noneOf(Painting.Flag.class), "");
                ResourceLocation identifier = PaintingRegisterPayload.handle(player, bufferedImage, p);
                if (identifier != null) {
                    painting.setMotive(identifier);
                }
                return true;
            }
        }
        return false;
    }
}

