/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.image.BufferedImage;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.registration.Configs;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PaintingWidget
extends Button {
    private BufferedImage image;
    private ResourceLocation identifier = Painting.DEFAULT_IDENTIFIER;
    private int paintingWidth = 256;
    private int paintingHeight = 256;
    private final Button.OnPress onPressRight;
    private int button;

    public PaintingWidget(int x, int y, int width, int height, Button.OnPress onPress, Button.OnPress onPressRight) {
        super(x, y, width, height, (Component)Component.literal((String)"Painting"), onPress, Button.DEFAULT_NARRATION);
        this.onPressRight = onPressRight;
    }

    @Nullable
    public BufferedImage getImage() {
        return this.image;
    }

    public void update(ResourceLocation identifier, BufferedImage image) {
        this.image = image;
        this.update(identifier, 4, 2);
    }

    public void update(ResourceLocation identifier, int paintingWidth, int paintingHeight) {
        int thumbnailSize = Configs.CLIENT.thumbnailSize;
        this.identifier = identifier;
        this.paintingWidth = paintingWidth * thumbnailSize;
        this.paintingHeight = paintingHeight * thumbnailSize;
    }

    public void onPress() {
        if (this.button == 0) {
            this.onPress.onPress((Button)this);
        } else {
            this.onPressRight.onPress((Button)this);
        }
    }

    protected boolean isValidClickButton(int button) {
        this.button = button;
        return button == 0 || button == 1;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        float scale = Math.min((float)this.width / (float)this.paintingWidth, (float)this.height / (float)this.paintingHeight);
        if (this.isHovered()) {
            scale *= 1.1f;
        }
        pose.translate((float)this.getX() + ((float)this.width - (float)this.paintingWidth * scale) / 2.0f, (float)this.getY() + ((float)this.height - (float)this.paintingHeight * scale) / 2.0f, 0.0f);
        pose.scale(scale, scale, 1.0f);
        graphics.blit(this.identifier, 0, 0, 0.0f, 0.0f, this.paintingWidth, this.paintingHeight, this.paintingWidth, this.paintingHeight);
        pose.popPose();
    }
}

