/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.event.ClientEventHandler;
import com.mrh0.createaddition.index.CAPartials;
import com.mrh0.createaddition.rendering.CARenderType;
import com.mrh0.createaddition.util.ClientMinecraftWrapper;
import com.mrh0.createaddition.util.Util;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class WireNodeRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final float HANG = 0.5f;
    private float time = 0.0f;
    static Color[] colors = new Color[]{Color.RED, Color.GREEN, new Color(0.0f, 0.0f, 1.0f, 1.0f)};
    static float LIGHT_Y_OFFSET = -0.03f;

    public WireNodeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T be, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IWireNode te = (IWireNode)be;
        this.time += partialTicks;
        for (int i = 0; i < te.getNodeCount(); ++i) {
            if (!te.hasConnection(i)) continue;
            Vec3 d1 = te.getNodeOffset(i);
            float ox1 = (float)d1.x();
            float oy1 = (float)d1.y();
            float oz1 = (float)d1.z();
            IWireNode wn = te.getWireNode(i);
            if (wn == null) {
                return;
            }
            Vec3 d2 = wn.getNodeOffset(te.getOtherNodeIndex(i));
            float ox2 = (float)d2.x();
            float oy2 = (float)d2.y();
            float oz2 = (float)d2.z();
            BlockPos other = te.getNodePos(i);
            float tx = other.getX() - te.getPos().getX();
            float ty = other.getY() - te.getPos().getY();
            float tz = other.getZ() - te.getPos().getZ();
            stack.pushPose();
            float dis = WireNodeRenderer.distanceFromZero(tx, ty, tz);
            stack.translate(tx + 0.5f + ox2, ty + 0.5f + oy2, tz + 0.5f + oz2);
            WireNodeRenderer.wireRender(be, other, stack, bufferIn, -tx - ox2 + ox1, -ty - oy2 + oy1, -tz - oz2 + oz1, te.getNodeType(i), dis);
            stack.popPose();
        }
        if (ClientEventHandler.clientRenderHeldWire) {
            LocalPlayer player = ClientMinecraftWrapper.getPlayer();
            Util.Triple<BlockPos, Integer, WireType> wireNode = Util.getWireNodeOfSpools(player.getInventory().getSelected());
            if (wireNode == null) {
                return;
            }
            BlockPos nodePos = (BlockPos)wireNode.a;
            int nodeIndex = (Integer)wireNode.b;
            WireType wireType = (WireType)((Object)wireNode.c);
            if (!nodePos.equals((Object)te.getPos())) {
                return;
            }
            Vec3 d1 = te.getNodeOffset(nodeIndex);
            float ox1 = (float)d1.x();
            float oy1 = (float)d1.y();
            float oz1 = (float)d1.z();
            Vec3 playerPos = player.getPosition(partialTicks);
            float tx = (float)playerPos.x - (float)te.getPos().getX();
            float ty = (float)playerPos.y - (float)te.getPos().getY();
            float tz = (float)playerPos.z - (float)te.getPos().getZ();
            stack.pushPose();
            float dis = WireNodeRenderer.distanceFromZero(tx, ty, tz);
            stack.translate(tx + 0.5f, ty + 0.5f, tz + 0.5f);
            WireNodeRenderer.wireRender(be, player.blockPosition(), stack, bufferIn, -tx + ox1, -ty + oy1, -tz + oz1, wireType, dis);
            stack.popPose();
        }
    }

    private static float divf(int a, int b) {
        return (float)a / (float)b;
    }

    private static float hang(float f, float dis) {
        return (float)Math.sin(-f * (float)Math.PI) * (0.5f * dis / (float)((Integer)CommonConfig.SMALL_CONNECTOR_MAX_LENGTH.get()).intValue());
    }

    public static float distanceFromZero(float x, float y, float z) {
        return (float)Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
    }

    public static void wireRender(BlockEntity tileEntityIn, BlockPos other, PoseStack stack, MultiBufferSource buffer, float x, float y, float z, WireType type, float dis) {
        VertexConsumer ivertexbuilder = buffer.getBuffer(CARenderType.WIRE);
        Matrix4f matrix4f = stack.last().pose();
        float f = (float)(Mth.fastInvSqrt((double)(x * x + z * z)) * (double)0.025f / 2.0);
        float o1 = z * f;
        float o2 = x * f;
        BlockPos blockpos1 = tileEntityIn.getBlockPos();
        BlockPos blockpos2 = other;
        int i = tileEntityIn.getLevel().getBrightness(LightLayer.BLOCK, blockpos1);
        int j = tileEntityIn.getLevel().getBrightness(LightLayer.BLOCK, blockpos2);
        int k = tileEntityIn.getLevel().getBrightness(LightLayer.SKY, blockpos1);
        int l = tileEntityIn.getLevel().getBrightness(LightLayer.SKY, blockpos2);
        WireNodeRenderer.wirePart(ivertexbuilder, matrix4f, x, y, z, j, i, l, k, 0.025f, 0.025f, o1, o2, type, dis, tileEntityIn.getBlockState(), stack, 0, 1.0f);
        WireNodeRenderer.wirePart(ivertexbuilder, matrix4f, x, y, z, j, i, l, k, 0.025f, 0.0f, o1, o2, type, dis, tileEntityIn.getBlockState(), stack, 1, 1.0f);
    }

    public static void wirePart(VertexConsumer vertBuilder, Matrix4f matrix, float x, float y, float z, int l1, int l2, int l3, int l4, float a, float b, float o1, float o2, WireType type, float dis, BlockState state, PoseStack stack, int lightOffset, float hangFactor) {
        for (int j = 0; j < 24; ++j) {
            float f = (float)j / 23.0f;
            int k = (int)Mth.lerp((float)f, (float)l1, (float)l2);
            int l = (int)Mth.lerp((float)f, (float)l3, (float)l4);
            int light = LightTexture.pack((int)k, (int)l);
            WireNodeRenderer.wireVert(vertBuilder, matrix, light, x, y, z, a, b, 24, j, false, o1, o2, type, dis, state, stack, lightOffset, hangFactor);
            WireNodeRenderer.wireVert(vertBuilder, matrix, light, x, y, z, a, b, 24, j + 1, true, o1, o2, type, dis, state, stack, lightOffset + 1, hangFactor);
        }
        if (type.isFestive()) {
            stack.pushPose();
            boolean main = x + y + z > 0.0f;
            for (int j = 0; j < 24; ++j) {
                WireNodeRenderer.lights(vertBuilder, x, y, z, a, b, 24, j + 1, o1, o2, type, dis, state, stack, lightOffset, main);
            }
            stack.popPose();
        }
    }

    public static void lights(VertexConsumer vertBuilder, float x, float y, float z, float a, float b, int count, int index, float o1, float o2, WireType type, float dis, BlockState state, PoseStack stack, int lightOffset, boolean main) {
        float part = (float)index / (float)count;
        float fx = x * part;
        float fy = (y > 0.0f ? y * part * part : y - y * (1.0f - part) * (1.0f - part)) + WireNodeRenderer.hang(WireNodeRenderer.divf(index, count), dis) + LIGHT_Y_OFFSET;
        float fz = z * part;
        if (index % 3 == 0 && index != 1 && index != count && lightOffset == 0) {
            ((SuperByteBuffer)CachedBuffers.partial((PartialModel)CAPartials.SMALL_LIGHT, (BlockState)state).color(colors[main ? 2 - index / 3 % 3 : index / 3 % 3]).light(255).translate(fx, fy, fz)).renderInto(stack, vertBuilder);
        }
    }

    public static void supports(VertexConsumer vertBuilder, float x, float y, float z, float a, float b, int count, int index, float o1, float o2, WireType type, float dis, BlockState state, PoseStack stack, int lightOffset, boolean main) {
        float part = (float)index / (float)count;
        float fx = x * part;
        float fyh = (y > 0.0f ? y * part * part : y - y * (1.0f - part) * (1.0f - part)) + 2.0f * WireNodeRenderer.hang(WireNodeRenderer.divf(index, count), dis);
        float fy = y > 0.0f ? y * part * part : y - y * (1.0f - part) * (1.0f - part);
        float fz = z * part;
        if (index % 3 == 0 && index != 1 && index != count && lightOffset == 0) {
            float l = 27.2f - fyh * 16.0f;
            ((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)CAPartials.SMALL_LIGHT, (BlockState)state).light(255).translate(fx, fy + WireNodeRenderer.hang(WireNodeRenderer.divf(index, count), dis), fz)).scale(0.5f, l, 0.5f)).renderInto(stack, vertBuilder);
        }
    }

    public static void wireVert(VertexConsumer vertBuilder, Matrix4f matrix, int light, float x, float y, float z, float a, float b, int count, int index, boolean sw, float o1, float o2, WireType type, float dis, BlockState state, PoseStack stack, int lightOffset, float hangFactor) {
        int cr = type.getRed();
        int cg = type.getGreen();
        int cb = type.getBlue();
        if (index % 2 == 0) {
            cr = (int)((float)cr * 0.7f);
            cg = (int)((float)cg * 0.7f);
            cb = (int)((float)cb * 0.7f);
        }
        float part = (float)index / (float)count;
        float fx = x * part;
        float fy = (y > 0.0f ? y * part * part : y - y * (1.0f - part) * (1.0f - part)) + hangFactor * WireNodeRenderer.hang(WireNodeRenderer.divf(index, count), dis);
        float fz = z * part;
        if (Math.abs(x) + Math.abs(z) < Math.abs(y)) {
            boolean p = b > 0.0f;
            float c = 0.015f;
            if (!sw) {
                vertBuilder.addVertex(matrix, fx - c, fy, fz + (p ? -c : c)).setColor(cr, cg, cb, 255).setLight(light);
            }
            vertBuilder.addVertex(matrix, fx + c, fy, fz + (p ? c : -c)).setColor(cr, cg, cb, 255).setLight(light);
            if (sw) {
                vertBuilder.addVertex(matrix, fx - c, fy, fz + (p ? -c : c)).setColor(cr, cg, cb, 255).setLight(light);
            }
        } else {
            if (!sw) {
                vertBuilder.addVertex(matrix, fx + o1, fy + a - b, fz - o2).setColor(cr, cg, cb, 255).setLight(light);
            }
            vertBuilder.addVertex(matrix, fx - o1, fy + b, fz + o2).setColor(cr, cg, cb, 255).setLight(light);
            if (sw) {
                vertBuilder.addVertex(matrix, fx + o1, fy + a - b, fz - o2).setColor(cr, cg, cb, 255).setLight(light);
            }
        }
    }
}

