/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar.search;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ContainerSearcher {
    public static List<Slot> search(String search, AbstractContainerMenu menu, int size) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < size; ++i) {
            Slot slot = menu.getSlot(i);
            ItemStack item = slot.getItem();
            if (!ContainerSearcher.checkItem(item, search)) continue;
            slots.add(slot);
        }
        return slots;
    }

    public static boolean checkItem(ItemStack item, String search) {
        if (item.isEmpty() || search.isEmpty()) {
            return false;
        }
        if (ContainerSearcher.checkName(item.getHoverName().getString(), search)) {
            return true;
        }
        if (item.isEnchanted() || item.getItem().equals(Items.ENCHANTED_BOOK)) {
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)item);
            for (Holder enc : enchantments.keySet()) {
                String name = Component.translatable((String)((Enchantment)enc.value()).description().getString()).getString() + " " + enchantments.getLevel(enc);
                if (!ContainerSearcher.checkName(name, search)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkName(String item, String search) {
        return item.toLowerCase().contains(search.toLowerCase());
    }
}

