/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar.mixin.client;

import cgcm.chestsearchbar.SearchHandler;
import cgcm.chestsearchbar.config.Config;
import cgcm.chestsearchbar.config.Mode;
import cgcm.chestsearchbar.gui.SearchBox;
import cgcm.chestsearchbar.input.Keybindings;
import cgcm.chestsearchbar.util.ContainerUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected final T menu;
    @Shadow
    protected int imageWidth;
    @Shadow
    protected int titleLabelX;
    @Shadow
    protected int titleLabelY;
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    protected Slot hoveredSlot;
    @Unique
    private SearchHandler searchHandler;
    @Unique
    private static long lastClick;

    @Shadow
    protected abstract boolean isHovering(int var1, int var2, int var3, int var4, double var5, double var7);

    @Shadow
    protected abstract boolean isHovering(Slot var1, double var2, double var4);

    protected AbstractContainerScreenMixin(T menu, Component pTitle) {
        super(pTitle);
        this.menu = menu;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo callbackinfo) {
        int pX;
        int barWidth;
        AbstractContainerScreen instance = (AbstractContainerScreen)this;
        Mode mode = Config.getMode(instance, ContainerUtil.getMenuSize(((AbstractContainerMenu)this.menu).slots.size()));
        if (instance instanceof CreativeModeInventoryScreen || instance instanceof InventoryScreen || instance instanceof CraftingScreen || mode == Mode.DISABLED) {
            return;
        }
        int pY = this.topPos + this.titleLabelY;
        if (Config.detachSearchBar) {
            barWidth = (int)((double)this.imageWidth * 0.6);
            pX = this.width / 2 - barWidth / 2;
            pY = Math.max(pY - 20, 1);
        } else {
            pX = this.leftPos + this.titleLabelX + (this.title.getString().isBlank() ? 0 : this.font.width(this.title.getString().replaceAll("\\p{C}", "")) + 3);
            int finalPos = this.leftPos + this.imageWidth - this.titleLabelX;
            pX = Math.min(pX, finalPos - 32);
            barWidth = finalPos - pX + 1;
        }
        SearchBox searchBar = new SearchBox(this.font, pX + 1, pY, barWidth, 9, Config.detachSearchBar);
        this.searchHandler = new SearchHandler(instance, searchBar, mode);
        this.addWidget((GuiEventListener)searchBar);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        if (this.searchHandler == null) {
            return;
        }
        this.searchHandler.getSearchBar().render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (!this.searchHandler.shouldUseSearch() || !this.searchHandler.isSortMode()) {
            return;
        }
        for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
            Slot posSlot = this.menu.getSlot(i);
            if (!this.isHovering(posSlot.x, posSlot.y, 16, 16, pMouseX, pMouseY) || !posSlot.isActive()) continue;
            this.hoveredSlot = i < this.searchHandler.getSearchResult().size() ? this.searchHandler.getSearchResult().get(i) : null;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V", shift=At.Shift.AFTER)})
    private void onRenderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        if (this.searchHandler != null && this.searchHandler.shouldUseSearch() && !this.searchHandler.isSortMode()) {
            for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
                Slot posSlot = this.menu.getSlot(i);
                if (this.searchHandler.getSearchResult().contains(posSlot)) continue;
                pGuiGraphics.fillGradient(RenderType.guiOverlay(), posSlot.x, posSlot.y, posSlot.x + 16, posSlot.y + 16, -1275068416, -1275068416, 0);
            }
        }
    }

    @Redirect(method={"renderSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;getItem()Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack redirectGetItem(Slot slot) {
        int index = slot.index;
        if (this.searchHandler == null || !this.searchHandler.shouldUseSearch() || !this.searchHandler.isSortMode() || index >= this.searchHandler.getMenuSize()) {
            return slot.getItem();
        }
        if (this.searchHandler.getSearchResult().size() > index) {
            return this.searchHandler.getSearchResult().get(index).getItem();
        }
        return ItemStack.EMPTY;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchHandler != null) {
            if (!this.searchHandler.getSearchBar().isMouseOver(pMouseX, pMouseY)) {
                this.searchHandler.getSearchBar().setFocused(false);
            } else {
                long time = System.currentTimeMillis();
                long d = time - lastClick;
                if (d < 200L && this.searchHandler.getSearchBar().isFocused() && !this.searchHandler.isBarEmpty()) {
                    this.searchHandler.getSearchBar().setValue("");
                    SearchHandler.search = "";
                }
                lastClick = time;
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchHandler != null) {
            if (this.searchHandler.getSearchBar().isFocused()) {
                if (pKeyCode != 256 && this.searchHandler.getSearchBar().isVisible()) {
                    this.searchHandler.getSearchBar().keyPressed(pKeyCode, pScanCode, pModifiers);
                    cir.setReturnValue((Object)true);
                }
            } else if (Keybindings.TOGGLE_SEARCH_BAR_KEY.matches(pKeyCode, pScanCode)) {
                boolean v = !this.searchHandler.getSearchBar().isVisible();
                this.searchHandler.getSearchBar().setVisible(v);
                SearchHandler.enabled = v;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.searchHandler != null) {
            this.searchHandler.tick();
        }
    }

    @ModifyVariable(method={"mouseDragged"}, name={"slot"}, at=@At(value="STORE"), ordinal=0)
    private Slot modifySlotInMouseDragged(Slot originalSlot, double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.searchHandler != null && this.searchHandler.isSortMode() && this.searchHandler.shouldUseSearch() && originalSlot != null && originalSlot.index < this.searchHandler.getMenuSize()) {
            return null;
        }
        return originalSlot;
    }

    @Inject(method={"findSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void findSlot(double pMouseX, double pMouseY, CallbackInfoReturnable<Slot> cir) {
        if (this.searchHandler != null && this.searchHandler.isSortMode() && this.searchHandler.shouldUseSearch()) {
            for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
                Slot slot = this.menu.getSlot(i);
                if (!this.isHovering(slot, pMouseX, pMouseY) || !slot.isActive()) continue;
                if (i < this.searchHandler.getSearchResult().size()) {
                    cir.setReturnValue((Object)this.searchHandler.getSearchResult().get(i));
                    continue;
                }
                cir.setReturnValue(null);
            }
        }
    }
}

