/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar;

import cgcm.chestsearchbar.config.Config;
import cgcm.chestsearchbar.config.Mode;
import cgcm.chestsearchbar.search.ContainerSearcher;
import cgcm.chestsearchbar.util.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;

public class SearchHandler {
    public static String search = "";
    public static boolean enabled = true;
    private final AbstractContainerScreen<?> screen;
    private final EditBox searchBar;
    private final Mode mode;
    private List<Slot> slots = new ArrayList<Slot>();

    public SearchHandler(AbstractContainerScreen<?> screen, EditBox searchBax, Mode mode) {
        this.screen = screen;
        this.searchBar = searchBax;
        this.mode = mode;
        if (Config.keepSearch) {
            this.searchBar.setValue(search);
        }
        if (Config.autoFocus && enabled) {
            this.searchBar.setFocused(true);
            screen.setFocused((GuiEventListener)this.searchBar);
        }
        this.searchBar.setVisible(enabled);
        this.searchBar.setResponder(this::refreshAndUpdate);
    }

    public List<Slot> getSearchResult() {
        return this.slots;
    }

    public EditBox getSearchBar() {
        return this.searchBar;
    }

    public boolean isBarEmpty() {
        return this.searchBar.getValue().isEmpty();
    }

    public boolean shouldUseSearch() {
        return !this.isBarEmpty() && this.searchBar.isVisible();
    }

    public int getMenuSize() {
        return ContainerUtil.getMenuSize(this.screen.getMenu().slots.size());
    }

    public void tick() {
        if (this.shouldUseSearch()) {
            this.refreshResults(this.searchBar.getValue());
        }
    }

    public void refreshAndUpdate(String search) {
        SearchHandler.search = search;
        this.refreshResults(search);
    }

    public void refreshResults(String search) {
        this.slots = ContainerSearcher.search(search, this.screen.getMenu(), this.getMenuSize());
        if (this.slots.isEmpty() && !this.isBarEmpty()) {
            this.searchBar.setTextColor(-39836);
        } else {
            this.searchBar.setTextColor(0xFFFFFF);
        }
    }

    public boolean isSortMode() {
        return this.mode == Mode.SORT;
    }
}

