/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.heat.plate;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.heat.HeatBlockEntity;
import org.antarcticgardens.cna.util.StringFormatUtil;
import org.jetbrains.annotations.Nullable;

public class SolarHeatingPlateBlockEntity
extends BlockEntity
implements HeatBlockEntity,
IHaveGoggleInformation {
    private final int energyPerSecond;
    private float last;
    public float heat = 0.0f;

    public SolarHeatingPlateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, int energyPerSecond) {
        super(type, pos, blockState);
        this.energyPerSecond = energyPerSecond;
    }

    public static SolarHeatingPlateBlockEntity createBasic(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new SolarHeatingPlateBlockEntity(type, pos, blockState, 20);
    }

    public static SolarHeatingPlateBlockEntity createAdvanced(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new SolarHeatingPlateBlockEntity(type, pos, blockState, 60);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.heat = tag.getFloat("heat");
        this.last = tag.getFloat("last");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putFloat("heat", this.heat);
        tag.putFloat("last", this.last);
    }

    @Override
    public boolean canConnect(Direction from) {
        return from != Direction.DOWN;
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.setChanged();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HeatBlockEntity.addToolTips(this, tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.generating", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_new_age.temperature.ps", (Object[])new Object[]{StringFormatUtil.formatFloat(this.last)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 2);
        return true;
    }

    public void tick(BlockPos blockPos, Level world, BlockState blockState) {
        double generationMultiplier = (Double)CNAConfig.getCommon().solarPanelHeatMultiplier.get();
        int dark = 0;
        if (world.isClientSide()) {
            double d = 1.0 - (double)(world.getRainLevel(1.0f) * 5.0f) / 16.0;
            double e = 1.0 - (double)(world.getThunderLevel(1.0f) * 5.0f) / 16.0;
            double f = 0.5 + 2.0 * Mth.clamp((double)Mth.cos((float)(world.getTimeOfDay(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
            dark = (int)((1.0 - f * d * e) * 11.0);
        } else {
            dark = world.getSkyDarken();
        }
        HeatBlockEntity.transferAround(this);
        HeatBlockEntity.handleOverheat(this);
        float light = world.getBrightness(LightLayer.SKY, blockPos.above()) - (dark *= 2);
        this.last = (float)Math.max((double)(light / 15.0f * (float)this.energyPerSecond) * generationMultiplier - Math.max(0.0, (double)this.heat - (double)(20 * this.energyPerSecond) * generationMultiplier), 0.0);
        this.addHeat(this.last);
        HeatBlockEntity.trySync(this);
    }
}

