/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.generation.coil;

import com.google.common.collect.Lists;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.antarcticgardens.cna.CNATags;
import org.antarcticgardens.cna.CreateNewAge;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.generation.magnet.IMagneticBlock;
import org.antarcticgardens.cna.util.RelativeBlockPos;
import org.antarcticgardens.cna.util.StringFormatUtil;

public class GeneratorCoilBlockEntity
extends KineticBlockEntity {
    public final List<BlockPos> magnetPositions;
    private float lastStress = 0.0f;
    private int generatedEnergy = 0;
    private float plainStress;

    public GeneratorCoilBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        RelativeBlockPos relativePosition = new RelativeBlockPos(this.worldPosition, (Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS));
        this.magnetPositions = Lists.newArrayList((Object[])new BlockPos[]{relativePosition.up(2).right(1).getPos(), relativePosition.up(2).getPos(), relativePosition.up(2).left(1).getPos(), relativePosition.left(2).up(1).getPos(), relativePosition.left(2).getPos(), relativePosition.left(2).down(1).getPos(), relativePosition.down(2).left(1).getPos(), relativePosition.down(2).getPos(), relativePosition.down(2).right(1).getPos(), relativePosition.right(2).down(1).getPos(), relativePosition.right(2).getPos(), relativePosition.right(2).up(1).getPos()});
        this.setLazyTickRate(20);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate(1.0);
    }

    public float calculateStressApplied() {
        float stress = this.plainStress = super.calculateStressApplied();
        block2: for (BlockPos pos : this.magnetPositions) {
            BlockState state = this.level.getBlockState(pos);
            if (!state.is(CNATags.Block.MAGNET.blockTag)) continue;
            Block block = state.getBlock();
            if (block instanceof IMagneticBlock) {
                IMagneticBlock magneticBlock = (IMagneticBlock)block;
                stress += magneticBlock.getStrength();
                continue;
            }
            for (TagKey blockTagKey : state.getTags().toList()) {
                String path;
                if (!blockTagKey.location().getNamespace().equals("create_new_age") || !(path = blockTagKey.location().getPath()).startsWith("magnet/force_")) continue;
                try {
                    stress += (float)Integer.parseInt(path.substring(13));
                    continue block2;
                }
                catch (NumberFormatException e) {
                    CreateNewAge.LOGGER.error("BAD TAG " + String.valueOf(blockTagKey) + " on item " + String.valueOf(state.getBlock()), (Throwable)e);
                }
            }
        }
        this.lastStressApplied = stress;
        return stress;
    }

    public void tick() {
        super.tick();
        this.generatedEnergy = (int)((double)((this.lastStressApplied - this.plainStress) * Math.abs(this.getSpeed())) * (Double)CNAConfig.getCommon().suToEnergy.get());
    }

    public void lazyTick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        float stress = this.calculateStressApplied();
        KineticNetwork network = this.getOrCreateNetwork();
        if (network != null && this.lastStress != stress) {
            network.updateStressFor((KineticBlockEntity)this, stress);
            network.updateStress();
            this.sendData();
            this.lastStress = stress;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.efficiency", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_new_age.percent", (Object[])new Object[]{StringFormatUtil.formatPercentFloat((this.lastStressApplied - this.plainStress) / this.lastStressApplied)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 2);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public int takeGeneratedEnergy() {
        int energy = this.generatedEnergy;
        this.generatedEnergy = 0;
        return energy;
    }
}

