/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark;

import dev.dediamondpro.resourcify.libs.commonmark.Extension;
import dev.dediamondpro.resourcify.libs.commonmark.node.Node;
import dev.dediamondpro.resourcify.libs.commonmark.renderer.html.HtmlRenderer;
import dev.dediamondpro.resourcify.libs.commonmark.renderer.html.UrlSanitizer;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.MineMarkCoreBuilder;
import dev.dediamondpro.resourcify.libs.minemark.MineMarkHtmlParser;
import dev.dediamondpro.resourcify.libs.minemark.elements.MineMarkElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.ElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.elements.creators.TextElementCreator;
import dev.dediamondpro.resourcify.libs.minemark.elements.formatting.FormattingElement;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import dev.dediamondpro.resourcify.libs.minemark.utils.HtmlWhiteSpaceUtil;
import dev.dediamondpro.resourcify.libs.tagsoup.Parser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MineMarkCore<S extends Style, R> {
    private final dev.dediamondpro.resourcify.libs.commonmark.parser.Parser markdownParser;
    private final HtmlRenderer htmlRenderer;
    private final MineMarkHtmlParser<S, R> htmlParser;
    private final Parser xmlParser;
    private final ReentrantLock parsingLock = new ReentrantLock();

    protected MineMarkCore(TextElementCreator<S, R> textElement, List<ElementCreator<S, R>> elements, List<FormattingElement<S, R>> formattingElements, Iterable<? extends Extension> extensions, @Nullable UrlSanitizer urlSanitizer) {
        this.markdownParser = dev.dediamondpro.resourcify.libs.commonmark.parser.Parser.builder().extensions(extensions).build();
        HtmlRenderer.Builder htmlRendererBuilder = HtmlRenderer.builder().extensions(extensions);
        if (urlSanitizer != null) {
            htmlRendererBuilder.urlSanitizer(urlSanitizer).sanitizeUrls(true);
        }
        this.htmlRenderer = htmlRendererBuilder.build();
        this.htmlParser = new MineMarkHtmlParser<S, R>(textElement, elements, formattingElements);
        this.xmlParser = new Parser();
        this.xmlParser.setContentHandler(this.htmlParser);
    }

    public MineMarkElement<S, R> parse(@NotNull S style, @NotNull String markdown, @NotNull Charset charSet) throws SAXException, IOException {
        Node document = this.markdownParser.parse(markdown);
        return this.parseDocument(style, document, charSet);
    }

    public MineMarkElement<S, R> parse(@NotNull S style, @NotNull String markdown) throws SAXException, IOException {
        return this.parse(style, markdown, StandardCharsets.UTF_8);
    }

    public MineMarkElement<S, R> parse(@NotNull S style, @NotNull Reader markdown, @NotNull Charset charSet) throws SAXException, IOException {
        Node document = this.markdownParser.parseReader(markdown);
        return this.parseDocument(style, document, charSet);
    }

    public MineMarkElement<S, R> parse(@NotNull S style, @NotNull Reader markdown) throws SAXException, IOException {
        return this.parse(style, markdown, StandardCharsets.UTF_8);
    }

    private MineMarkElement<S, R> parseDocument(@NotNull S style, Node document, @NotNull Charset charSet) throws SAXException, IOException {
        String html = this.htmlRenderer.render(document);
        String wrapper = this.getMineMarkWrapper(html);
        html = "<" + wrapper + ">" + html + "</" + wrapper + ">";
        html = HtmlWhiteSpaceUtil.INSTANCE.removeUnnecessaryWhiteSpace(html);
        this.parsingLock.lock();
        try {
            MineMarkElement<S, R> mineMarkElement;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(html.getBytes(charSet));){
                this.htmlParser.setStyle(style, new LayoutStyle((Style)style));
                this.htmlParser.setWrapper(wrapper);
                InputSource source = new InputSource(stream);
                source.setEncoding(charSet.name());
                this.xmlParser.parse(source);
                mineMarkElement = this.htmlParser.getParsedResult();
            }
            return mineMarkElement;
        }
        finally {
            this.htmlParser.cleanUp();
            this.parsingLock.unlock();
        }
    }

    private String getMineMarkWrapper(String html) {
        String wrapper = "minemark";
        int num = 0;
        while (html.contains(wrapper)) {
            wrapper = "minemark-" + num;
            ++num;
        }
        return wrapper;
    }

    public static <S extends Style, R> MineMarkCoreBuilder<S, R> builder() {
        return new MineMarkCoreBuilder();
    }
}

