/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.gui.world;

import dev.dediamondpro.resourcify.Constants;
import dev.dediamondpro.resourcify.gui.PaginatedScreen;
import dev.dediamondpro.resourcify.libs.universal.UScreen;
import dev.dediamondpro.resourcify.util.DownloadManager;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 /2\u00020\u0001:\u0001/B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0017\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010'\u001a\u0004\b(\u0010)R\u0018\u0010+\u001a\u0004\u0018\u00010*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u00060"}, d2={"Ldev/dediamondpro/resourcify/gui/world/WorldDownloadingScreen;", "Lnet/minecraft/client/gui/screens/GenericMessageScreen;", "Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "parent", "Ljava/io/File;", "world", "Ljava/net/URI;", "uri", "<init>", "(Ldev/dediamondpro/resourcify/gui/PaginatedScreen;Ljava/io/File;Ljava/net/URI;)V", "", "init", "()V", "repositionElements", "tick", "Lnet/minecraft/network/chat/Component;", "newText", "updateText", "(Lnet/minecraft/network/chat/Component;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "mouseX", "mouseY", "", "partialTick", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "getTextWidth", "()I", "", "shouldCloseOnEsc", "()Z", "Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "getParent", "()Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "Ljava/io/File;", "getWorld", "()Ljava/io/File;", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "Lnet/minecraft/client/gui/components/Button;", "cancelButton", "Lnet/minecraft/client/gui/components/Button;", "triggeredLoad", "Z", "Companion", "Resourcify (1.21.1-neoforge)-1.7.5"})
public final class WorldDownloadingScreen
extends GenericMessageScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PaginatedScreen parent;
    @NotNull
    private final File world;
    @NotNull
    private final URI uri;
    @Nullable
    private Button cancelButton;
    private boolean triggeredLoad;

    public WorldDownloadingScreen(@NotNull PaginatedScreen parent, @NotNull File world, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object[] objectArray = new Object[]{0};
        super((Component)Component.translatable((String)"resourcify.world.downloading", (Object[])objectArray));
        this.parent = parent;
        this.world = world;
        this.uri = uri;
    }

    @NotNull
    public final PaginatedScreen getParent() {
        return this.parent;
    }

    @NotNull
    public final File getWorld() {
        return this.world;
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    protected void init() {
        super.init();
        int width = this.getTextWidth();
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)Component.translatable((String)"resourcify.world.cancel")), arg_0 -> WorldDownloadingScreen.init$lambda$0(this, arg_0)).width(width + 24).pos(this.width / 2 - width / 2 - 12, this.height / 2 + 20).build());
    }

    protected void repositionElements() {
        block2: {
            super.repositionElements();
            int width = this.getTextWidth();
            Button button = this.cancelButton;
            if (button != null) {
                button.setWidth(width + 24);
            }
            Button button2 = this.cancelButton;
            if (button2 != null) {
                button2.setX(this.width / 2 - width / 2 - 12);
            }
            Button button3 = this.cancelButton;
            if (button3 == null) break block2;
            button3.setY(this.height / 2 + 20);
        }
    }

    public void tick() {
        super.tick();
        Float progress = DownloadManager.INSTANCE.getProgress(this.uri);
        if (progress != null) {
            Object[] objectArray = new Object[]{(int)Math.rint((double)progress.floatValue() * 100.0)};
            MutableComponent mutableComponent = Component.translatable((String)"resourcify.world.downloading", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            this.updateText((Component)mutableComponent);
            this.repositionElements();
            return;
        }
        if (this.triggeredLoad) {
            return;
        }
        this.triggeredLoad = true;
        String string = this.world.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Companion.openWorld(string);
    }

    private final void updateText(Component newText) {
        block0: {
            FocusableTextWidget focusableTextWidget = this.textWidget;
            if (focusableTextWidget == null) break block0;
            focusableTextWidget.setMessage(newText);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private final int getTextWidth() {
        FocusableTextWidget focusableTextWidget = this.textWidget;
        Intrinsics.checkNotNull((Object)focusableTextWidget);
        return focusableTextWidget.getWidth();
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    private static final void init$lambda$0(WorldDownloadingScreen this$0, Button it) {
        DownloadManager.INSTANCE.cancelDownload(this$0.uri);
        UScreen.Companion.displayScreen(this$0.parent);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/dediamondpro/resourcify/gui/world/WorldDownloadingScreen$Companion;", "", "<init>", "()V", "", "name", "", "openWorld", "(Ljava/lang/String;)V", "Lnet/minecraft/client/gui/screens/Screen;", "createFailScreen", "(Ljava/lang/String;)Lnet/minecraft/client/gui/screens/Screen;", "Resourcify (1.21.1-neoforge)-1.7.5"})
    public static final class Companion {
        private Companion() {
        }

        public final void openWorld(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Minecraft minecraft = Minecraft.getInstance();
            if (!minecraft.getLevelSource().levelExists(name)) {
                Constants.INSTANCE.getLOGGER().error("Failed to open world " + name + ", it doesn't exist");
                UScreen.Companion.displayScreen(this.createFailScreen(name));
            } else {
                MultiThreadingKt.runAsync(() -> Companion.openWorld$lambda$2(minecraft, name));
            }
        }

        private final Screen createFailScreen(String name) {
            Object[] objectArray = new Object[]{name};
            return (Screen)new DisconnectedScreen((Screen)new SelectWorldScreen((Screen)new TitleScreen()), (Component)Component.translatable((String)"resourcify.world.failed"), (Component)Component.translatable((String)"resourcify.world.failed.description", (Object[])objectArray), (Component)Component.translatable((String)"gui.toWorld"));
        }

        private static final void openWorld$lambda$2$lambda$1$lambda$0(String $name) {
            Constants.INSTANCE.getLOGGER().error("Failed to open world " + $name);
            UScreen.Companion.displayScreen(Companion.createFailScreen($name));
        }

        private static final void openWorld$lambda$2$lambda$1(Minecraft $minecraft, String $name) {
            $minecraft.createWorldOpenFlows().openWorld($name, () -> Companion.openWorld$lambda$2$lambda$1$lambda$0($name));
        }

        private static final void openWorld$lambda$2(Minecraft $minecraft, String $name) {
            $minecraft.execute(() -> Companion.openWorld$lambda$2$lambda$1($minecraft, $name));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

