/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.items.handheld_saw;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndesires.DnDesires;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HandheldSawRenderer
extends CustomRenderedItemModelRenderer {
    protected static final PartialModel COG = PartialModel.of((ResourceLocation)DnDesires.loc("item/handheld_saw/cog"));
    LerpedFloat lerpSwing = LerpedFloat.linear();

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        renderer.render(model.getOriginalModel(), light);
        float angle = 0.5f;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer instanceof LocalPlayer) {
            LocalPlayer player = localPlayer;
            ItemStack hand = player.getMainHandItem();
            boolean inMainHand = ItemStack.isSameItemSameComponents((ItemStack)hand, (ItemStack)stack) && stack.equals(hand) && stack.hashCode() == hand.hashCode();
            boolean held = mc.options.keyAttack.isDown() || mc.options.keyAttack.consumeClick();
            boolean playerHeldKey = player.getPersistentData().getBoolean("HandheldSawKey");
            if (inMainHand) {
                angle += held ? 2.5f : 0.5f;
            }
            if (playerHeldKey) {
                angle *= 2.0f;
            }
            this.lerpSwing.chase((double)((this.lerpSwing.getValue() + angle) % 36000.0f), 0.03125, LerpedFloat.Chaser.EXP);
            this.lerpSwing.tickChaser();
            angle = this.lerpSwing.getValue(AnimationTickHolder.getPartialTicks()) % 360.0f;
            angle *= -2.0f;
        }
        ms.pushPose();
        ms.mulPose(Axis.ZP.rotationDegrees(angle));
        renderer.render(COG.get(), light);
        ms.popPose();
    }
}

