/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.util.biome;

import biomesoplenty.api.block.BOPBlocks;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;

public class RoseQuartzUtils {
    public static double getRoseQuartzHeight(double p_159624_, double p_159625_, double p_159626_, double p_159627_) {
        if (p_159624_ < p_159627_) {
            p_159624_ = p_159627_;
        }
        double d0 = 0.384;
        double d1 = p_159624_ / p_159625_ * 0.384;
        double d2 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = p_159626_ * (d2 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * p_159625_;
    }

    public static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel p_159640_, BlockPos p_159641_, int p_159642_) {
        if (RoseQuartzUtils.isEmptyOrWaterOrLava((LevelAccessor)p_159640_, p_159641_)) {
            return false;
        }
        float f = 6.0f;
        float f1 = 6.0f / (float)p_159642_;
        for (float f2 = 0.0f; f2 < (float)Math.PI * 2; f2 += f1) {
            int j;
            int i = (int)(Mth.cos((float)f2) * (float)p_159642_);
            if (!RoseQuartzUtils.isEmptyOrWaterOrLava((LevelAccessor)p_159640_, p_159641_.offset(i, 0, j = (int)(Mth.sin((float)f2) * (float)p_159642_)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyOrWater(LevelAccessor p_159629_, BlockPos p_159630_) {
        return p_159629_.isStateAtPosition(p_159630_, RoseQuartzUtils::isEmptyOrWater);
    }

    public static boolean isEmptyOrWaterOrLava(LevelAccessor p_159660_, BlockPos p_159661_) {
        return p_159660_.isStateAtPosition(p_159661_, RoseQuartzUtils::isEmptyOrWaterOrLava);
    }

    public static void buildBaseToTipColumn(Direction p_159652_, int p_159653_, boolean p_159654_, Consumer<BlockState> p_159655_) {
        if (p_159653_ >= 3) {
            p_159655_.accept(RoseQuartzUtils.createPointedRoseQuartz(p_159652_, DripstoneThickness.BASE));
            for (int i = 0; i < p_159653_ - 3; ++i) {
                p_159655_.accept(RoseQuartzUtils.createPointedRoseQuartz(p_159652_, DripstoneThickness.MIDDLE));
            }
        }
        if (p_159653_ >= 2) {
            p_159655_.accept(RoseQuartzUtils.createPointedRoseQuartz(p_159652_, DripstoneThickness.FRUSTUM));
        }
        if (p_159653_ >= 1) {
            p_159655_.accept(RoseQuartzUtils.createPointedRoseQuartz(p_159652_, p_159654_ ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    public static void growPointedRoseQuartz(WorldGenLevel p_159644_, BlockPos p_159645_, Direction p_159646_, int p_159647_, boolean p_159648_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_159645_.mutable();
        RoseQuartzUtils.buildBaseToTipColumn(p_159646_, p_159647_, p_159648_, p_159635_ -> {
            if (p_159635_.is(Blocks.POINTED_DRIPSTONE)) {
                p_159635_ = (BlockState)p_159635_.setValue((Property)PointedDripstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(p_159644_.isWaterAt((BlockPos)blockpos$mutableblockpos)));
            }
            p_159644_.setBlock((BlockPos)blockpos$mutableblockpos, p_159635_, 2);
            blockpos$mutableblockpos.move(p_159646_);
        });
    }

    public static boolean placeRoseQuartzBlockIfPossible(WorldGenLevel p_159637_, BlockPos p_159638_) {
        BlockState blockstate = p_159637_.getBlockState(p_159638_);
        if (blockstate.is(Blocks.NETHERRACK)) {
            p_159637_.setBlock(p_159638_, BOPBlocks.ROSE_QUARTZ_BLOCK.defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    public static BlockState createPointedRoseQuartz(Direction p_159657_, DripstoneThickness p_159658_) {
        return (BlockState)((BlockState)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue((Property)PointedDripstoneBlock.TIP_DIRECTION, (Comparable)p_159657_)).setValue((Property)PointedDripstoneBlock.THICKNESS, (Comparable)p_159658_);
    }

    public static boolean isRoseQuartzBaseOrLava(BlockState p_159650_) {
        return RoseQuartzUtils.isRoseQuartzBase(p_159650_) || p_159650_.is(Blocks.LAVA);
    }

    public static boolean isRoseQuartzBase(BlockState p_159663_) {
        return p_159663_.is(BOPBlocks.ROSE_QUARTZ_BLOCK) || p_159663_.is(Blocks.NETHERRACK);
    }

    public static boolean isEmptyOrWater(BlockState p_159665_) {
        return p_159665_.isAir() || p_159665_.is(Blocks.WATER);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState p_159667_) {
        return p_159667_.isAir() || p_159667_.is(Blocks.WATER) || p_159667_.is(Blocks.LAVA);
    }
}

