/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.util;

import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class TradesHelper {
    public static final int MAX_USES = 12;
    public static final float PRICE_MULTIPLIER = 0.05f;

    public static BaseTrade forEmeralds(int emeraldCost, ItemStack stack, int villagerXp) {
        return TradesHelper.forEmeralds(emeraldCost, stack, 12, villagerXp);
    }

    public static BaseTrade forEmeralds(int emeraldCost, ItemStack stack, int maxUses, int villagerXp) {
        return TradesHelper.forEmeralds(emeraldCost, stack, maxUses, villagerXp, 0.05f);
    }

    public static BaseTrade forEmeralds(int emeraldCost, ItemStack stack, int maxUses, int villagerXp, float priceMultiplier) {
        return new BaseTrade(new ItemStack((ItemLike)Items.EMERALD, emeraldCost), stack, maxUses, villagerXp, priceMultiplier);
    }

    public static BaseTrade forItems(ItemStack stack, int emeraldCount, int villagerXp) {
        return TradesHelper.forItems(stack, emeraldCount, 12, villagerXp);
    }

    public static BaseTrade forItems(ItemStack stack, int emeraldCount, int maxUses, int villagerXp) {
        return TradesHelper.forItems(stack, emeraldCount, maxUses, villagerXp, 0.05f);
    }

    public static BaseTrade forItems(ItemStack stack, int emeraldCount, int maxUses, int villagerXp, float priceMultiplier) {
        return new BaseTrade(stack, new ItemStack((ItemLike)Items.EMERALD, emeraldCount), maxUses, villagerXp, priceMultiplier);
    }

    public record BaseTrade(ItemStack price, ItemStack stack, int maxUses, int villagerXp, float priceMultiplier) implements VillagerTrades.ItemListing
    {
        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemCost((ItemLike)this.price.getItem(), this.price.getCount()), this.stack, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

