/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.registration.family;

import einstein.jmc.JustMoreCakes;
import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.data.CakeModel;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.registration.family.CakeFamily;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class DefaultCakeFamily
extends CakeFamily {
    protected DefaultCakeFamily(String flavorName, boolean noSuffix) {
        super(JustMoreCakes.loc(flavorName), flavorName + (noSuffix ? "" : "_cake"));
    }

    public static Builder create(String flavorName) {
        return DefaultCakeFamily.create(flavorName, false);
    }

    public static Builder create(String flavorName, boolean noSuffix) {
        return new Builder(flavorName, noSuffix);
    }

    public Supplier<BaseCakeBlock> getBaseCake() {
        return super.getBaseCake();
    }

    public static class Builder
    extends CakeFamily.Builder<DefaultCakeFamily> {
        private BlockBehaviour.Properties cakeProperties;
        private BlockBehaviour.Properties candleCakeProperties;

        private Builder(String flavorName, boolean noSuffix) {
            super(new DefaultCakeFamily(flavorName, noSuffix));
        }

        public Builder modifyBaseBuilder(Consumer<CakeVariant.Builder> consumer) {
            consumer.accept(this.baseVariantBuilder);
            return this;
        }

        public Builder modifyTwoTieredBuilder(Consumer<CakeVariant.Builder> consumer) {
            consumer.accept(this.twoTieredVariantBuilder);
            return this;
        }

        public Builder modifyThreeTieredBuilder(Consumer<CakeVariant.Builder> consumer) {
            consumer.accept(this.threeTieredVariantBuilder);
            return this;
        }

        public Builder cakeProperties(BlockBehaviour.Properties properties) {
            this.cakeProperties = properties;
            return this;
        }

        public Builder candleCakeProperties(BlockBehaviour.Properties properties) {
            this.candleCakeProperties = properties;
            return this;
        }

        public Builder nutrition(int nutrition) {
            ((DefaultCakeFamily)this.family).nutrition = nutrition;
            return this;
        }

        public Builder saturationModifier(float modifier) {
            ((DefaultCakeFamily)this.family).saturationModifier = modifier;
            return this;
        }

        public Builder alwaysEat() {
            ((DefaultCakeFamily)this.family).canAlwaysEat = true;
            return this;
        }

        public Builder model(CakeModel model) {
            return this.models(model, CakeModel.DEFAULT);
        }

        public Builder models(CakeModel cakeModel, CakeModel candleCakeModel) {
            ((DefaultCakeFamily)this.family).cakeModel = cakeModel;
            ((DefaultCakeFamily)this.family).candleCakeModel = candleCakeModel;
            return this;
        }

        @Override
        public DefaultCakeFamily build() {
            if (((DefaultCakeFamily)this.family).canAlwaysEat) {
                this.baseVariantBuilder.alwaysEat();
                this.twoTieredVariantBuilder.alwaysEat();
                this.threeTieredVariantBuilder.alwaysEat();
            }
            ((DefaultCakeFamily)this.family).baseVariant = this.baseVariantBuilder.cakeProperties(this.cakeProperties).candleCakeProperties(this.candleCakeProperties).nutrition(((DefaultCakeFamily)this.family).nutrition).saturationModifier(((DefaultCakeFamily)this.family).saturationModifier).models(((DefaultCakeFamily)this.family).cakeModel, ((DefaultCakeFamily)this.family).candleCakeModel).build();
            ((DefaultCakeFamily)this.family).twoTieredVariant = this.twoTieredVariantBuilder.noItem().cakeProperties(this.cakeProperties).candleCakeProperties(this.candleCakeProperties).nutrition(((DefaultCakeFamily)this.family).nutrition).saturationModifier(((DefaultCakeFamily)this.family).saturationModifier).models(((DefaultCakeFamily)this.family).cakeModel, ((DefaultCakeFamily)this.family).candleCakeModel).build();
            ((DefaultCakeFamily)this.family).threeTieredVariant = this.threeTieredVariantBuilder.noItem().cakeProperties(this.cakeProperties).candleCakeProperties(this.candleCakeProperties).nutrition(((DefaultCakeFamily)this.family).nutrition).saturationModifier(((DefaultCakeFamily)this.family).saturationModifier).models(((DefaultCakeFamily)this.family).cakeModel, ((DefaultCakeFamily)this.family).candleCakeModel).build();
            return (DefaultCakeFamily)super.build();
        }
    }
}

