/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.platform;

import einstein.jmc.platform.services.RegistryHelper;
import einstein.jmc.util.BlockEntitySupplier;
import einstein.jmc.util.MenuTypeSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeRegistryHelper
implements RegistryHelper {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"jmc");
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"jmc");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"jmc");
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((Registry)BuiltInRegistries.POTION, (String)"jmc");
    public static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((Registry)BuiltInRegistries.MOB_EFFECT, (String)"jmc");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"jmc");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"jmc");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"jmc");
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"jmc");
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"jmc");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"jmc");
    public static final DeferredRegister<GameEvent> GAME_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.GAME_EVENT, (String)"jmc");
    public static final DeferredRegister<CriterionTrigger<?>> TRIGGER_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.TRIGGER_TYPES, (String)"jmc");

    @Override
    public <T extends Item> Supplier<T> registerItem(String name, Supplier<T> type) {
        DeferredItem item = ITEMS.register(name, type);
        CREATIVE_TAB_ITEMS.add(item);
        return item;
    }

    @Override
    public <T extends Block> Supplier<T> registerBlockNoItem(String name, Supplier<T> type) {
        return BLOCKS.register(name, type);
    }

    @Override
    public <T extends BlockEntityType<?>> Supplier<T> registerBlockEntity(String name, Supplier<T> type) {
        return BLOCK_ENTITIES.register(name, type);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntity(BlockEntitySupplier<T> supplier, Block ... blocks) {
        return BlockEntityType.Builder.of(supplier::create, (Block[])blocks).build(null);
    }

    @Override
    public Supplier<Holder<Potion>> registerPotion(String name, Supplier<Potion> type) {
        DeferredHolder potionHolder = POTIONS.register(name, type);
        return () -> potionHolder;
    }

    @Override
    public Supplier<Holder<MobEffect>> registerMobEffect(String name, Supplier<MobEffect> type) {
        DeferredHolder effectHolder = MOB_EFFECTS.register(name, type);
        return () -> effectHolder;
    }

    @Override
    public <T extends RecipeSerializer<?>> Supplier<T> registerRecipeSerializer(String name, Supplier<T> type) {
        return RECIPE_SERIALIZERS.register(name, type);
    }

    @Override
    public <T extends RecipeType<?>> Supplier<T> registerRecipeType(String name, Supplier<T> type) {
        return RECIPE_TYPES.register(name, type);
    }

    @Override
    public <T extends MenuType<?>> Supplier<T> registerMenuType(String name, Supplier<T> type) {
        return MENU_TYPES.register(name, type);
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(MenuTypeSupplier<T> supplier) {
        return new MenuType(supplier::create, FeatureFlags.DEFAULT_FLAGS);
    }

    @Override
    public <T extends PoiType> Supplier<T> registerPOIType(String name, Supplier<T> type) {
        return POI_TYPES.register(name, type);
    }

    @Override
    public <T extends VillagerProfession> Supplier<T> registerVillagerProfession(String name, Supplier<T> type) {
        return VILLAGER_PROFESSIONS.register(name, type);
    }

    @Override
    public <T extends CreativeModeTab> Supplier<T> registerCreativeModeTab(String name, Function<CreativeModeTab.Builder, T> type) {
        return CREATIVE_MODE_TABS.register(name, () -> (CreativeModeTab)type.apply(CreativeModeTab.builder()));
    }

    @Override
    public Supplier<Holder<GameEvent>> registerGameEvent(String name, Supplier<GameEvent> type) {
        DeferredHolder gameEventHolder = GAME_EVENTS.register(name, type);
        return () -> NeoForgeRegistryHelper.lambda$registerGameEvent$3((Holder)gameEventHolder);
    }

    @Override
    public <T extends CriterionTrigger<?>> Supplier<T> registerTriggerType(String name, Supplier<T> type) {
        return TRIGGER_TYPES.register(name, type);
    }

    private static /* synthetic */ Holder lambda$registerGameEvent$3(Holder gameEventHolder) {
        return gameEventHolder;
    }
}

