/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.network.clientbound;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import einstein.jmc.JustMoreCakes;
import einstein.jmc.data.effects.CakeEffects;
import einstein.jmc.data.effects.CakeEffectsManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ClientboundCakeEffectsPacket {
    public static final ResourceLocation CHANNEL = JustMoreCakes.loc("cake_effects");
    private final List<CakeEffects> cakeEffects;

    public ClientboundCakeEffectsPacket(List<CakeEffects> cakeEffects) {
        this.cakeEffects = cakeEffects;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.cakeEffects.size());
        this.cakeEffects.forEach(cakeEffects -> CakeEffects.STREAM_CODEC.encode((Object)buf, cakeEffects));
    }

    public static ClientboundCakeEffectsPacket decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<CakeEffects> cakeEffects = new ArrayList<CakeEffects>();
        for (int i = 0; i < size; ++i) {
            cakeEffects.add((CakeEffects)CakeEffects.STREAM_CODEC.decode((Object)buf));
        }
        return new ClientboundCakeEffectsPacket(cakeEffects);
    }

    public static void handle(PacketContext<ClientboundCakeEffectsPacket> context) {
        if (context.side().equals((Object)Side.CLIENT)) {
            CakeEffectsManager.clearCakeEffects();
            ((ClientboundCakeEffectsPacket)context.message()).cakeEffects.forEach(CakeEffectsManager::setEffectsOnHolder);
            JustMoreCakes.LOGGER.info("Received cake effects from server");
        }
    }
}

