/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.menu.cakeoven;

import einstein.jmc.block.entity.CakeOvenBlockEntity;
import einstein.jmc.platform.Services;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CakeOvenResultSlot
extends Slot {
    private final Player player;
    private int removeCount;

    public CakeOvenResultSlot(Player player, Container container, int slotId, int x, int y) {
        super(container, slotId, x, y);
        this.player = player;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        Container container = this.container;
        if (container instanceof CakeOvenBlockEntity) {
            CakeOvenBlockEntity cakeOvenBlockEntity = (CakeOvenBlockEntity)container;
            for (int i = 0; i < cakeOvenBlockEntity.getRemainingItems().size(); ++i) {
                ItemStack remainingItem = (ItemStack)cakeOvenBlockEntity.getRemainingItems().get(i);
                if (remainingItem.isEmpty()) continue;
                if (!player.getInventory().add(remainingItem)) {
                    player.drop(remainingItem, false);
                }
                cakeOvenBlockEntity.getRemainingItems().set(i, (Object)ItemStack.EMPTY);
            }
        }
        super.onTake(player, stack);
    }

    protected void onQuickCraft(ItemStack resultStack, int resultCount) {
        this.removeCount += resultCount;
        this.checkTakeAchievements(resultStack);
    }

    protected void checkTakeAchievements(ItemStack resultStack) {
        resultStack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = this.container;
            if (player instanceof CakeOvenBlockEntity) {
                CakeOvenBlockEntity blockEntity = (CakeOvenBlockEntity)player;
                blockEntity.awardUsedRecipesAndPopExperience(serverPlayer);
            }
        }
        this.removeCount = 0;
        Services.HOOKS.fireSmeltEvent(this.player, resultStack);
    }
}

