/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.menu.cakeoven;

import einstein.jmc.init.ModMenuTypes;
import einstein.jmc.menu.cakeoven.CakeOvenFuelSlot;
import einstein.jmc.menu.cakeoven.CakeOvenResultSlot;
import einstein.jmc.platform.Services;
import einstein.jmc.util.CakeOvenConstants;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CakeOvenMenu
extends AbstractContainerMenu
implements CakeOvenConstants {
    private final Container container;
    private final ContainerData data;

    public CakeOvenMenu(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(4));
    }

    public CakeOvenMenu(int id, Inventory inventory, Container container, ContainerData data) {
        super(ModMenuTypes.CAKE_OVEN.get(), id);
        CakeOvenMenu.checkContainerSize((Container)container, (int)6);
        CakeOvenMenu.checkContainerDataCount((ContainerData)data, (int)4);
        this.container = container;
        this.data = data;
        this.addSlot(new Slot(container, 0, 52, 26));
        this.addSlot(new Slot(container, 1, 70, 26));
        this.addSlot(new Slot(container, 2, 52, 44));
        this.addSlot(new Slot(container, 3, 70, 44));
        this.addSlot(new CakeOvenFuelSlot(this, container, 4, 19, 44));
        this.addSlot(new CakeOvenResultSlot(inventory.player, container, 5, 130, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 142));
        }
        this.addDataSlots(data);
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack stack1 = slot.getItem();
            stack = stack1.copy();
            int containerSize = 6;
            int inventoryEnd = containerSize + 27;
            int hotbarEnd = inventoryEnd + 9;
            if (slotIndex == 5) {
                if (!this.moveItemStackTo(stack1, containerSize, hotbarEnd, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack1, stack);
            } else if (slotIndex >= containerSize) {
                if (this.isFuel(stack1)) {
                    if (!this.moveItemStackTo(stack1, 4, containerSize, false)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    if (!this.moveItemStackTo(stack1, 0, 4, false)) {
                        return ItemStack.EMPTY;
                    }
                    if (slotIndex < inventoryEnd ? !this.moveItemStackTo(stack1, inventoryEnd, hotbarEnd, false) : slotIndex < hotbarEnd && !this.moveItemStackTo(stack1, containerSize, inventoryEnd, false)) {
                        return ItemStack.EMPTY;
                    }
                }
            } else if (!this.moveItemStackTo(stack1, containerSize, hotbarEnd, false)) {
                return ItemStack.EMPTY;
            }
            if (stack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack1.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack1);
        }
        return stack;
    }

    protected boolean isFuel(ItemStack stack) {
        return Services.HOOKS.getBurnTime(stack) > 0;
    }

    public float getBurnProgress() {
        int cookingProgress = this.data.get(2);
        int cookingTotalTime = this.data.get(3);
        return cookingTotalTime != 0 && cookingProgress != 0 ? Mth.clamp((float)((float)cookingProgress / (float)cookingTotalTime), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public float getLitProgress() {
        int litDuration = this.data.get(1);
        if (litDuration == 0) {
            litDuration = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)litDuration), (float)0.0f, (float)1.0f);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    public Container getContainer() {
        return this.container;
    }
}

