/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import einstein.jmc.item.crafting.CakeOvenRecipe;
import einstein.jmc.util.CakeOvenConstants;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CakeOvenRecipeSerializer
implements RecipeSerializer<CakeOvenRecipe>,
CakeOvenConstants {
    private static final MapCodec<CakeOvenRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
        Object[] filteredIngredients = (Ingredient[])ingredients.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
        if (filteredIngredients.length == 0) {
            return DataResult.error(() -> "No ingredients for cake oven recipe");
        }
        return filteredIngredients.length > 4 ? DataResult.error(() -> "Too many ingredients for cake oven recipe. The max is 4") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])filteredIngredients));
    }, DataResult::success).forGetter(recipe -> recipe.ingredients), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)ExtraCodecs.POSITIVE_INT.fieldOf("cookingTime").orElse((Object)100).forGetter(recipe -> recipe.cookingTime)).apply((Applicative)instance, CakeOvenRecipe::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, CakeOvenRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.result);
        buf.writeFloat(recipe.experience);
        buf.writeVarInt(recipe.cookingTime);
        buf.writeByte(recipe.ingredients.size());
        recipe.ingredients.forEach(ingredient -> Ingredient.CONTENTS_STREAM_CODEC.encode(buf, ingredient));
    }, buf -> {
        ItemStack resultStack = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
        float experience = buf.readFloat();
        int cookTime = buf.readVarInt();
        byte ingredientCount = buf.readByte();
        NonNullList ingredients = NonNullList.withSize((int)ingredientCount, (Object)Ingredient.EMPTY);
        ingredients.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf));
        return new CakeOvenRecipe((NonNullList<Ingredient>)ingredients, resultStack, experience, cookTime);
    });

    public MapCodec<CakeOvenRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, CakeOvenRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

