/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.init;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.block.entity.CakeOvenBlockEntity;
import einstein.jmc.block.entity.CakeStandBlockEntity;
import einstein.jmc.block.entity.CeramicBowlBlockEntity;
import einstein.jmc.block.entity.GlowstoneCakeBlockEntity;
import einstein.jmc.block.entity.TNTCakeBlockEntity;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.platform.Services;
import einstein.jmc.registration.family.DefaultCakeFamily;
import einstein.jmc.util.BlockEntitySupplier;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ModBlockEntityTypes {
    public static final Supplier<BlockEntityType<GlowstoneCakeBlockEntity>> GLOWSTONE_CAKE = ModBlockEntityTypes.registerForFamily("glowstone_cake", GlowstoneCakeBlockEntity::new, ModBlocks.GLOWSTONE_CAKE_FAMILY);
    public static final Supplier<BlockEntityType<TNTCakeBlockEntity>> TNT_CAKE = ModBlockEntityTypes.registerForCake("tnt_cake", TNTCakeBlockEntity::new, ModBlocks.TNT_CAKE_VARIANT.getCake());
    public static final Supplier<BlockEntityType<CakeOvenBlockEntity>> CAKE_OVEN = ModBlockEntityTypes.register("cake_oven", CakeOvenBlockEntity::new, ModBlocks.CAKE_OVEN);
    public static final Supplier<BlockEntityType<CakeStandBlockEntity>> CAKE_STAND = ModBlockEntityTypes.register("cake_stand", CakeStandBlockEntity::new, ModBlocks.CAKE_STAND);
    public static final Supplier<BlockEntityType<CeramicBowlBlockEntity>> CERAMIC_BOWL = ModBlockEntityTypes.register("ceramic_bowl", CeramicBowlBlockEntity::new, ModBlocks.CERAMIC_BOWL);

    public static void init() {
    }

    private static <T extends BlockEntity> Supplier<BlockEntityType<T>> registerForFamily(String name, BlockEntitySupplier<T> supplier, DefaultCakeFamily family) {
        return Services.REGISTRY.registerBlockEntity(name, () -> {
            ArrayList cakes = new ArrayList();
            family.forEach(cake -> {
                cakes.add(cake);
                cakes.addAll(((BaseCakeBlock)cake.get()).getVariant().getCandleCakeByCandle().values());
            });
            return Services.REGISTRY.createBlockEntity(supplier, (Block[])cakes.stream().map(Supplier::get).toArray(Block[]::new));
        });
    }

    private static <T extends BlockEntity> Supplier<BlockEntityType<T>> registerForCake(String name, BlockEntitySupplier<T> supplier, Supplier<? extends BaseCakeBlock> cake) {
        return Services.REGISTRY.registerBlockEntity(name, () -> {
            ArrayList<Supplier<BaseCandleCakeBlock>> cakes = new ArrayList<Supplier<BaseCandleCakeBlock>>(((BaseCakeBlock)cake.get()).getVariant().getCandleCakeByCandle().values());
            cakes.add(cake);
            return Services.REGISTRY.createBlockEntity(supplier, (Block[])cakes.stream().map(Supplier::get).toArray(Block[]::new));
        });
    }

    private static <T extends BlockEntity> Supplier<BlockEntityType<T>> register(String name, BlockEntitySupplier<T> supplier, Supplier<? extends Block> block) {
        return Services.REGISTRY.registerBlockEntity(name, () -> Services.REGISTRY.createBlockEntity(supplier, (Block)block.get()));
    }
}

