/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import einstein.jmc.init.ModVillagers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HarvestSugarCane
extends Behavior<Villager> {
    @Nullable
    private BlockPos sugarCanePos;
    private long nextStartTime;
    private int timeWorked;
    private final List<BlockPos> validSugarCanePositions = new ArrayList<BlockPos>();

    public HarvestSugarCane() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.SECONDARY_JOB_SITE, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Villager villager) {
        if (!level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (villager.getVillagerData().getProfession() != ModVillagers.CAKE_BAKER.get()) {
            return false;
        }
        this.validSugarCanePositions.clear();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(villager.getX() + (double)x, villager.getY() + (double)y, villager.getZ() + (double)z);
                    if (!this.validPos((BlockPos)pos, level)) continue;
                    this.validSugarCanePositions.add((BlockPos)pos);
                }
            }
        }
        this.sugarCanePos = this.getValidSugarCane(level);
        return this.sugarCanePos != null;
    }

    private boolean validPos(BlockPos pos, ServerLevel level) {
        BlockState state = level.getBlockState(pos);
        BlockState belowState = level.getBlockState(pos.below());
        return state.getBlock() instanceof SugarCaneBlock && belowState.getBlock() instanceof SugarCaneBlock;
    }

    @Nullable
    private BlockPos getValidSugarCane(ServerLevel level) {
        return this.validSugarCanePositions.isEmpty() ? null : this.validSugarCanePositions.get(level.getRandom().nextInt(this.validSugarCanePositions.size()));
    }

    protected void start(ServerLevel level, Villager villager, long gameTime) {
        if (gameTime > this.nextStartTime && this.sugarCanePos != null) {
            this.setMemories(villager);
        }
    }

    protected void stop(ServerLevel level, Villager villager, long gameTime) {
        Brain brain = villager.getBrain();
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        this.timeWorked = 0;
        this.nextStartTime = gameTime + 40L;
    }

    protected void tick(ServerLevel level, Villager villager, long gameTime) {
        if (this.sugarCanePos == null || this.sugarCanePos.closerToCenterThan((Position)villager.position().add(0.0, 1.0, 0.0), 1.0)) {
            BlockState state;
            Block block;
            if (this.sugarCanePos != null && gameTime > this.nextStartTime && (block = (state = level.getBlockState(this.sugarCanePos)).getBlock()) instanceof SugarCaneBlock) {
                level.destroyBlock(this.sugarCanePos, true, (Entity)villager);
                this.validSugarCanePositions.remove(this.sugarCanePos);
                this.sugarCanePos = this.getValidSugarCane(level);
                if (this.sugarCanePos != null) {
                    this.nextStartTime = gameTime + 20L;
                    this.setMemories(villager);
                }
            }
            ++this.timeWorked;
        }
    }

    protected boolean canStillUse(ServerLevel level, Villager villager, long gameTime) {
        return this.timeWorked < 200;
    }

    private void setMemories(Villager villager) {
        if (this.sugarCanePos != null) {
            Brain brain = villager.getBrain();
            BlockPosTracker tracker = new BlockPosTracker(this.sugarCanePos);
            brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)tracker);
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)tracker, 0.5f, 1));
        }
    }
}

