/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import einstein.jmc.block.CakeEffectsHolder;
import einstein.jmc.data.effects.CakeEffects;
import einstein.jmc.registration.family.CakeFamily;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.block.Block;

public abstract class CakeEffectsProvider
implements DataProvider {
    private final PackOutput output;
    private final String modId;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final Map<String, CakeEffects> toSerialize = new HashMap<String, CakeEffects>();

    public CakeEffectsProvider(PackOutput output, String modId, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.output = output;
        this.modId = modId;
        this.lookupProvider = lookupProvider;
    }

    protected abstract void generate();

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.lookupProvider.thenCompose(provider -> {
            this.generate();
            Path folderPath = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("jmc/cake_effect");
            ImmutableList.Builder builder = new ImmutableList.Builder();
            RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            this.toSerialize.forEach((path, cakeEffects) -> {
                JsonElement element = (JsonElement)CakeEffects.CODEC.encodeStart((DynamicOps)ops, cakeEffects).getOrThrow();
                Path filePath = folderPath.resolve(path + ".json");
                builder.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)element, (Path)filePath));
            });
            return CompletableFuture.allOf((CompletableFuture[])builder.build().toArray(CompletableFuture[]::new));
        });
    }

    public <T extends Block> void add(Supplier<T> block, MobEffectInstance ... instances) {
        this.add("block/" + BuiltInRegistries.BLOCK.getKey((Object)((Block)block.get())).getPath(), new CakeEffects(block, instances));
    }

    public void add(CakeFamily family, MobEffectInstance ... instances) {
        this.add("family/" + family.getRegistryKey().getPath(), new CakeEffects((CakeEffectsHolder)family, instances));
    }

    public void add(String path, CakeEffects cakeEffects) {
        this.toSerialize.put(path, cakeEffects);
    }

    public final String getName() {
        return "Cake Effects";
    }
}

