/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.compat.jade;

import einstein.jmc.JustMoreCakes;
import einstein.jmc.block.CakeOvenBlock;
import einstein.jmc.block.CakeStandBlock;
import einstein.jmc.block.CeramicBowlBlock;
import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.block.entity.CakeOvenBlockEntity;
import einstein.jmc.block.entity.CeramicBowlBlockEntity;
import einstein.jmc.compat.jade.providers.CakeEffectsProvider;
import einstein.jmc.compat.jade.providers.CakeNourishmentProvider;
import einstein.jmc.compat.jade.providers.CakeOvenProvider;
import einstein.jmc.compat.jade.providers.CakeStandProvider;
import einstein.jmc.compat.jade.providers.CandleTypeProvider;
import einstein.jmc.compat.jade.providers.CeramicBowlProvider;
import einstein.jmc.compat.jade.providers.ItemStorageRemoverProvider;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModServerConfigs;
import einstein.jmc.util.CakeUtil;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public class ModJadePlugin
implements IWailaPlugin {
    public static final CakeNourishmentProvider CAKE_NOURISHMENT_COMPONENT_PROVIDER = new CakeNourishmentProvider();
    public static final CakeEffectsProvider CAKE_EFFECT_PROVIDER = new CakeEffectsProvider();
    public static final CakeOvenProvider CAKE_OVEN_PROVIDER = new CakeOvenProvider();
    public static final ItemStorageRemoverProvider ITEM_STORAGE_REMOVER_PROVIDER = new ItemStorageRemoverProvider();
    public static final CandleTypeProvider CANDLE_TYPE_PROVIDER = new CandleTypeProvider();
    public static final CeramicBowlProvider CERAMIC_BOWL_PROVIDER = new CeramicBowlProvider();
    public static final CakeStandProvider CAKE_STAND_PROVIDER = new CakeStandProvider();
    public static final ResourceLocation CAKE_NOURISHMENT = JustMoreCakes.loc("cake_nourishment");
    public static final ResourceLocation CAKE_EFFECTS = JustMoreCakes.loc("cake_effects");
    public static final ResourceLocation CAKE_OVEN = JustMoreCakes.loc("cake_oven");
    public static final ResourceLocation ITEM_STORAGE_REMOVER = JustMoreCakes.loc("cake_oven.item_storage_remover");
    public static final ResourceLocation CANDLE_TYPE = JustMoreCakes.loc("candle_type");
    public static final ResourceLocation CERAMIC_BOWL = JustMoreCakes.loc("ceramic_bowl");
    public static final ResourceLocation CAKE_STAND = JustMoreCakes.loc("cake_stand");
    public static final ResourceLocation DISPLAY_TYPE = JustMoreCakes.loc("cake_nourishment.display_type");
    public static final ResourceLocation FOOD_ICONS_PER_LINE = JustMoreCakes.loc("cake_nourishment.food_icons_per_line");
    public static final ResourceLocation SHOW_NUTRITION = JustMoreCakes.loc("cake_nourishment.show_nutrition");
    public static final ResourceLocation SHOW_SATURATION = JustMoreCakes.loc("cake_nourishment.show_saturation");
    public static final ResourceLocation HIDE_TRAPPED_CAKES = JustMoreCakes.loc("hide_trapped_cakes");

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)CAKE_OVEN_PROVIDER, CakeOvenBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)CERAMIC_BOWL_PROVIDER, CeramicBowlBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(DISPLAY_TYPE, (Enum)CakeInfoDisplayType.TOTAL);
        registration.addConfig(FOOD_ICONS_PER_LINE, 10, 5, 30, false);
        registration.addConfig(SHOW_NUTRITION, true);
        registration.addConfig(SHOW_SATURATION, true);
        registration.addConfig(HIDE_TRAPPED_CAKES, false);
        registration.registerBlockComponent((IComponentProvider)CAKE_NOURISHMENT_COMPONENT_PROVIDER, BaseCakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CAKE_NOURISHMENT_COMPONENT_PROVIDER, BaseCandleCakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CAKE_NOURISHMENT_COMPONENT_PROVIDER, CakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CAKE_NOURISHMENT_COMPONENT_PROVIDER, CandleCakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CANDLE_TYPE_PROVIDER, BaseCandleCakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CANDLE_TYPE_PROVIDER, CandleCakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CAKE_EFFECT_PROVIDER, BaseCakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CAKE_EFFECT_PROVIDER, BaseCandleCakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CAKE_EFFECT_PROVIDER, CakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CAKE_EFFECT_PROVIDER, CandleCakeBlock.class);
        registration.registerBlockComponent((IComponentProvider)CAKE_OVEN_PROVIDER, CakeOvenBlock.class);
        registration.registerBlockComponent((IComponentProvider)ITEM_STORAGE_REMOVER_PROVIDER, CakeOvenBlock.class);
        registration.registerBlockComponent((IComponentProvider)CERAMIC_BOWL_PROVIDER, CeramicBowlBlock.class);
        registration.registerBlockComponent((IComponentProvider)CAKE_STAND_PROVIDER, CakeStandBlock.class);
        registration.addRayTraceCallback((hitResult, accessor, unmodifiedAccessor) -> {
            if ((((Boolean)ModServerConfigs.HIDE_TRAPPED_CAKES.get()).booleanValue() || IWailaConfig.get().getPlugin().get(HIDE_TRAPPED_CAKES)) && accessor instanceof BlockAccessor) {
                BlockAccessor blockAccessor = (BlockAccessor)accessor;
                Block block = blockAccessor.getBlock();
                BlockState state = blockAccessor.getBlockState();
                if (block.equals(ModBlocks.TNT_CAKE_VARIANT.getCake().get()) || block.equals(ModBlocks.POISON_CAKE_VARIANT.getCake().get())) {
                    return registration.blockAccessor().from(blockAccessor).blockEntity(() -> null).blockState((BlockState)Blocks.CAKE.defaultBlockState().setValue((Property)CakeBlock.BITES, (Comparable)((Integer)state.getValue((Property)BaseCakeBlock.BITES)))).build();
                }
                if (ModJadePlugin.isTrappedCandleCake(block, ModBlocks.TNT_CAKE_VARIANT.getCake().get()) || ModJadePlugin.isTrappedCandleCake(block, ModBlocks.POISON_CAKE_VARIANT.getCake().get())) {
                    return registration.blockAccessor().from(blockAccessor).blockEntity(() -> null).blockState((BlockState)((Block)CakeUtil.VANILLA_CANDLE_CAKES_BY_CANDLE.get((Object)((BaseCandleCakeBlock)block).getCandle())).defaultBlockState().setValue((Property)CandleCakeBlock.LIT, (Comparable)((Boolean)state.getValue((Property)BaseCandleCakeBlock.LIT)))).build();
                }
            }
            return accessor;
        });
        registration.markAsClientFeature(CAKE_NOURISHMENT);
        registration.markAsClientFeature(DISPLAY_TYPE);
        registration.markAsClientFeature(FOOD_ICONS_PER_LINE);
        registration.markAsClientFeature(SHOW_NUTRITION);
        registration.markAsClientFeature(SHOW_SATURATION);
        registration.markAsClientFeature(HIDE_TRAPPED_CAKES);
        registration.markAsClientFeature(CANDLE_TYPE);
        registration.markAsClientFeature(CAKE_STAND);
    }

    private static boolean isTrappedCandleCake(Block block, BaseCakeBlock cake) {
        if (block instanceof BaseCandleCakeBlock) {
            BaseCandleCakeBlock candleCake = (BaseCandleCakeBlock)block;
            return cake.getVariant().getCandleCakeByCandle().values().stream().map(Supplier::get).toList().contains((Object)candleCake);
        }
        return false;
    }

    public static void addItemToTooltip(ITooltip tooltip, Block block) {
        IElementHelper helper = IElementHelper.get();
        ItemStack stack = new ItemStack((ItemLike)block);
        if (!stack.isEmpty()) {
            tooltip.add(helper.smallItem(stack).clearCachedMessage());
            tooltip.append((IElement)helper.text((Component)Component.literal((String)" ").append((Component)block.getName())));
            return;
        }
        tooltip.add((IElement)helper.text((Component)block.getName()));
    }

    public static enum CakeInfoDisplayType {
        TOTAL,
        PER_SLICE;

    }
}

