/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.client.renderers.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import einstein.jmc.block.CeramicBowlBlock;
import einstein.jmc.block.entity.CeramicBowlBlockEntity;
import einstein.jmc.data.BowlContents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class CeramicBowlRenderer
implements BlockEntityRenderer<CeramicBowlBlockEntity> {
    public static final float ITEM_SCALE = 0.375f;
    public static final float CENTER_X = 0.3125f;
    private final ItemRenderer itemRenderer;

    public CeramicBowlRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(CeramicBowlBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        int fillLevel = (Integer)blockEntity.getBlockState().getValue((Property)CeramicBowlBlock.FILL_LEVEL);
        if (fillLevel > 0) {
            ResourceLocation texture = ((BowlContents)blockEntity.getContents().value()).texture();
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
            poseStack.pushPose();
            poseStack.translate(0.5, 0.0, 0.5);
            PoseStack.Pose last = poseStack.last();
            Matrix4f pose = last.pose();
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.solid());
            float minU = sprite.getU(0.1875f);
            float maxU = sprite.getU(0.8125f);
            float minV = sprite.getV(0.1875f);
            float maxV = sprite.getV(0.8125f);
            float y = 0.1875f + (float)fillLevel * 0.0625f;
            vertexConsumer.addVertex(pose, -0.3125f, y, -0.3125f).setColor(255, 255, 255, 1).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(last, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, -0.3125f, y, 0.3125f).setColor(255, 255, 255, 1).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(last, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, 0.3125f, y, 0.3125f).setColor(255, 255, 255, 1).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(last, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, 0.3125f, y, -0.3125f).setColor(255, 255, 255, 1).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(last, 0.0f, 1.0f, 0.0f);
            poseStack.popPose();
        }
        if (!blockEntity.isEmpty()) {
            Level level = blockEntity.getLevel();
            int seed = (int)blockEntity.getBlockPos().asLong();
            for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
                if (i == 4) continue;
                ItemStack stack = blockEntity.getItem(i);
                poseStack.pushPose();
                poseStack.translate(0.5, (double)i * 1.0E-4, 0.5);
                poseStack.mulPose(Axis.YP.rotationDegrees((float)(90 * i)));
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                poseStack.translate(-0.125, 0.0, -0.125);
                poseStack.scale(0.375f, 0.375f, 0.375f);
                this.itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, level, seed + i);
                poseStack.popPose();
            }
        }
    }
}

