/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.entity;

import einstein.jmc.block.CeramicBowlBlock;
import einstein.jmc.block.entity.CakeOvenBlockEntity;
import einstein.jmc.data.BowlContents;
import einstein.jmc.init.ModBlockEntityTypes;
import einstein.jmc.init.ModRecipes;
import einstein.jmc.item.crafting.ContainerRecipeInput;
import einstein.jmc.item.crafting.MixingRecipe;
import einstein.jmc.util.Util;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class CeramicBowlBlockEntity
extends BlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    public static final int INGREDIENT_SLOT_COUNT = 4;
    public static final int SLOT_COUNT = 5;
    public static final int DEFAULT_MIXING_PROGRESS = 5;
    public static final int RESULT_SLOT = 4;
    private final NonNullList<ItemStack> stacks = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> remainingItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<ContainerRecipeInput, MixingRecipe> quickCheck = RecipeManager.createCheck(ModRecipes.MIXING_RECIPE.get());
    private int mixingProgress;
    private Holder<BowlContents> contentsHolder = BowlContents.EMPTY.getHolder();

    public CeramicBowlBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.CERAMIC_BOWL.get(), pos, state);
    }

    public boolean tryCraft(Player player) {
        RecipeHolder<MixingRecipe> recipeHolder;
        MixingRecipe recipe;
        ItemStack resultStack;
        Optional<RecipeHolder<MixingRecipe>> matchingRecipe = this.getMatchingRecipe();
        if (matchingRecipe.isPresent() && !(resultStack = (recipe = (MixingRecipe)(recipeHolder = matchingRecipe.get()).value()).assemble(new ContainerRecipeInput((Container)this), (HolderLookup.Provider)this.level.registryAccess())).isEmpty()) {
            if (this.mixingProgress < recipe.getMixingTime() - 1 && !this.isEmpty()) {
                ++this.mixingProgress;
                float fillPercent = (float)this.mixingProgress / (float)recipe.getMixingTime();
                this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CeramicBowlBlock.FILL_LEVEL, (Comparable)Integer.valueOf((int)(fillPercent * 4.0f))));
                this.contentsHolder = BowlContents.getHolder(this.level, recipe.getContentsId());
                this.contentsChanged(player);
                return true;
            }
            for (int i = 0; i < this.stacks.size(); ++i) {
                Item item;
                if (i == 4 || !(item = ((ItemStack)this.stacks.get(i)).getItem()).hasCraftingRemainingItem()) continue;
                CeramicBowlBlockEntity.addToStackList(new ItemStack((ItemLike)item.getCraftingRemainingItem()), this.remainingItems, this.getMaxStackSize());
            }
            this.setResult(resultStack);
            recipe.consumeIngredients(this);
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CeramicBowlBlock.FILL_LEVEL, (Comparable)Integer.valueOf(4)));
            this.contentsChanged(player);
            this.setRecipeUsed(recipeHolder);
            this.awardUsedRecipes(player, (List<ItemStack>)this.stacks);
            return true;
        }
        return false;
    }

    public boolean addItem(Player player, ItemStack stack) {
        if (this.mixingProgress <= 0) {
            for (int i = 0; i < this.stacks.size(); ++i) {
                ItemStack currentStack;
                if (i == 4 || !(currentStack = this.getItem(i)).isEmpty()) continue;
                this.stacks.set(i, (Object)stack.split(1));
                this.contentsChanged(player);
                return true;
            }
        }
        return false;
    }

    private static boolean addToStackList(ItemStack stack, NonNullList<ItemStack> stacks, int maxStackSize) {
        int emptySlot = -1;
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack currentStack = (ItemStack)stacks.get(i);
            if (!CakeOvenBlockEntity.canAddToStack(stack, currentStack, maxStackSize, 1)) continue;
            if (currentStack.is(stack.getItem())) {
                currentStack.grow(1);
                return true;
            }
            if (!currentStack.isEmpty() || emptySlot != -1) continue;
            emptySlot = i;
        }
        if (emptySlot > -1) {
            stacks.set(emptySlot, (Object)stack.copyWithCount(1));
            return true;
        }
        return false;
    }

    public boolean takeItem(Player player) {
        if (!this.isEmpty() && this.mixingProgress <= 0) {
            for (int i = this.stacks.size() - 1; i > -1; --i) {
                ItemStack currentStack;
                if (i == 4 || (currentStack = this.getItem(i)).isEmpty()) continue;
                Block.popResourceFromFace((Level)this.level, (BlockPos)this.worldPosition, (Direction)Direction.UP, (ItemStack)currentStack);
                this.stacks.set(i, (Object)ItemStack.EMPTY);
                this.contentsChanged(player);
                return true;
            }
        }
        return false;
    }

    public boolean takeResult(Player player) {
        ItemStack result = this.getResult();
        if (!result.isEmpty()) {
            this.clear(false);
            result.onCraftedBy(this.level, player, result.getCount());
            Block.popResourceFromFace((Level)this.level, (BlockPos)this.worldPosition, (Direction)Direction.UP, (ItemStack)result);
            for (ItemStack remainingStack : this.remainingItems) {
                Block.popResourceFromFace((Level)this.level, (BlockPos)this.worldPosition, (Direction)Direction.UP, (ItemStack)remainingStack);
            }
            this.remainingItems.clear();
            this.setResult(ItemStack.EMPTY);
            this.contentsChanged(player);
            return true;
        }
        return false;
    }

    private void clear(boolean update) {
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CeramicBowlBlock.FILL_LEVEL, (Comparable)Integer.valueOf(0)));
        this.contentsHolder = BowlContents.EMPTY.getHolder();
        this.mixingProgress = 0;
        if (update) {
            this.setChanged();
        }
    }

    private void contentsChanged(Player player) {
        this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.worldPosition, GameEvent.Context.of((Entity)player, (BlockState)this.getBlockState()));
        this.setUpdated();
    }

    private void setUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void dropItems(Level level, BlockPos pos) {
        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.getResult());
        Containers.dropContents((Level)level, (BlockPos)pos, this.stacks);
        Containers.dropContents((Level)level, (BlockPos)pos, this.remainingItems);
        this.remainingItems.clear();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int[] getSlotsForFace(Direction direction) {
        if (direction == Direction.DOWN) {
            return new int[]{4};
        }
        return new int[]{0, 1, 2, 3};
    }

    public boolean canPlaceItemThroughFace(int slotIndex, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(slotIndex, stack);
    }

    public boolean canTakeItemThroughFace(int slotIndex, ItemStack stack, Direction direction) {
        return true;
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slotIndex) {
        return (ItemStack)this.stacks.get(slotIndex);
    }

    public ItemStack removeItem(int slotIndex, int count) {
        ItemStack stack = ContainerHelper.removeItem(this.stacks, (int)slotIndex, (int)count);
        if (!stack.isEmpty() && this.hasLevel()) {
            this.clear(true);
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slotIndex) {
        return ContainerHelper.takeItem(this.stacks, (int)slotIndex);
    }

    public void setItem(int slotIndex, ItemStack stack) {
        ItemStack currentStack = (ItemStack)this.stacks.get(slotIndex);
        boolean isSameStack = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentStack);
        this.stacks.set(slotIndex, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (!isSameStack) {
            this.setUpdated();
        }
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public boolean canPlaceItem(int slotIndex, ItemStack stack) {
        return ((ItemStack)this.stacks.get(slotIndex)).isEmpty();
    }

    public void clearContent() {
        this.stacks.clear();
        if (this.hasLevel()) {
            this.clear(true);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)provider);
        this.contentsHolder.unwrapKey().ifPresent(key -> tag.putString("Contents", key.location().toString()));
        return tag;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.stacks.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)provider);
        ContainerHelper.loadAllItems((CompoundTag)tag.getCompound("RemainingItems"), this.remainingItems, (HolderLookup.Provider)provider);
        this.setResult(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("ResultStack")));
        RegistryAccess v = Util.getRegistryAccess();
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString("Contents"))).map(id -> BowlContents.getHolder(this.level, id)).ifPresent(holder -> {
            this.contentsHolder = holder;
        });
        this.mixingProgress = tag.getInt("MixingProgress");
        CompoundTag usedRecipes = tag.getCompound("RecipesUsed");
        for (String recipeId : usedRecipes.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)recipeId), usedRecipes.getInt(recipeId));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)provider);
        CompoundTag remainingItemsTag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)remainingItemsTag, this.remainingItems, (HolderLookup.Provider)provider);
        tag.put("RemainingItems", (Tag)remainingItemsTag);
        tag.put("ResultStack", this.getResult().saveOptional(provider));
        this.contentsHolder.unwrapKey().ifPresent(key -> tag.putString("Contents", key.location().toString()));
        tag.putInt("MixingProgress", this.mixingProgress);
        CompoundTag recipesUsed = new CompoundTag();
        this.recipesUsed.forEach((recipeId, i) -> recipesUsed.putInt(recipeId.toString(), i.intValue()));
        tag.put("RecipesUsed", (Tag)recipesUsed);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.recipesUsed.addTo((Object)recipe.id(), 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> stacks) {
        if (this.level.isClientSide) {
            return;
        }
        ArrayList recipeHolders = new ArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            this.level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(holder -> {
                recipeHolders.add(holder);
                player.triggerRecipeCrafted(holder, stacks);
            });
        }
        player.awardRecipes(recipeHolders);
        this.recipesUsed.clear();
    }

    public void fillStackedContents(StackedContents contents) {
        for (ItemStack stack : this.stacks) {
            contents.accountStack(stack);
        }
    }

    public Holder<BowlContents> getContents() {
        return this.contentsHolder;
    }

    public ItemStack getResult() {
        return (ItemStack)this.stacks.get(4);
    }

    public void setResult(ItemStack result) {
        this.stacks.set(4, (Object)result);
    }

    public int getMixingProgress() {
        return this.mixingProgress;
    }

    public Optional<RecipeHolder<MixingRecipe>> getMatchingRecipe() {
        return this.quickCheck.getRecipeFor((RecipeInput)new ContainerRecipeInput((Container)this), this.level);
    }
}

