/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.entity;

import einstein.jmc.block.CakeOvenBlock;
import einstein.jmc.init.ModBlockEntityTypes;
import einstein.jmc.init.ModRecipes;
import einstein.jmc.item.crafting.CakeOvenRecipe;
import einstein.jmc.item.crafting.ContainerRecipeInput;
import einstein.jmc.menu.MenuDataProvider;
import einstein.jmc.menu.cakeoven.CakeOvenMenu;
import einstein.jmc.platform.Services;
import einstein.jmc.util.CakeOvenConstants;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CakeOvenBlockEntity
extends BaseContainerBlockEntity
implements MenuDataProvider,
WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible,
CakeOvenConstants {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
    private NonNullList<ItemStack> remainingItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<ContainerRecipeInput, CakeOvenRecipe> quickCheck = RecipeManager.createCheck(ModRecipes.CAKE_OVEN_RECIPE.get());
    private final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> CakeOvenBlockEntity.this.litTime;
                case 1 -> CakeOvenBlockEntity.this.litDuration;
                case 2 -> CakeOvenBlockEntity.this.cookingProgress;
                case 3 -> CakeOvenBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    CakeOvenBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    CakeOvenBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    CakeOvenBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    CakeOvenBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public CakeOvenBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.CAKE_OVEN.get(), pos, state);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.jmc.cake_oven");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new CakeOvenMenu(id, inventory, (Container)this, this.dataAccess);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CakeOvenBlockEntity blockEntity) {
        boolean hasIngredient;
        boolean wasLit = blockEntity.isLit();
        boolean update = false;
        if (blockEntity.isLit()) {
            --blockEntity.litTime;
        }
        ItemStack fuelStack = (ItemStack)blockEntity.items.get(4);
        boolean bl = hasIngredient = !((ItemStack)blockEntity.items.get(0)).isEmpty() || !((ItemStack)blockEntity.items.get(1)).isEmpty() || !((ItemStack)blockEntity.items.get(2)).isEmpty() || !((ItemStack)blockEntity.items.get(3)).isEmpty();
        if (blockEntity.isLit() || !fuelStack.isEmpty() && hasIngredient) {
            RecipeHolder recipe = hasIngredient ? (RecipeHolder)blockEntity.quickCheck.getRecipeFor((RecipeInput)new ContainerRecipeInput((Container)blockEntity), level).orElse(null) : null;
            int stackSize = blockEntity.getMaxStackSize();
            RegistryAccess access = level.registryAccess();
            if (!blockEntity.isLit() && blockEntity.hasResultSpace(access, (RecipeHolder<CakeOvenRecipe>)recipe, hasIngredient, stackSize)) {
                blockEntity.litDuration = blockEntity.litTime = blockEntity.getBurnDuration(fuelStack);
                if (blockEntity.isLit()) {
                    update = true;
                    Item remainingItem = fuelStack.getItem().getCraftingRemainingItem();
                    if (fuelStack.getItem().hasCraftingRemainingItem()) {
                        blockEntity.items.set(4, (Object)(remainingItem == null ? ItemStack.EMPTY : new ItemStack((ItemLike)remainingItem)));
                    } else if (!fuelStack.isEmpty()) {
                        fuelStack.shrink(1);
                        if (fuelStack.isEmpty()) {
                            blockEntity.items.set(4, (Object)(remainingItem == null ? ItemStack.EMPTY : new ItemStack((ItemLike)remainingItem)));
                        }
                    }
                }
            }
            if (blockEntity.isLit() && blockEntity.hasResultSpace(access, (RecipeHolder<CakeOvenRecipe>)recipe, hasIngredient, stackSize)) {
                ++blockEntity.cookingProgress;
                if (blockEntity.cookingProgress == blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = CakeOvenBlockEntity.getTotalCookTime(level, blockEntity);
                    if (blockEntity.smeltRecipe(access, (RecipeHolder<CakeOvenRecipe>)recipe, hasIngredient, stackSize)) {
                        blockEntity.setRecipeUsed(recipe);
                    }
                    update = true;
                }
            } else {
                blockEntity.cookingProgress = 0;
            }
        } else if (!blockEntity.isLit() && blockEntity.cookingProgress > 0) {
            blockEntity.cookingProgress = Mth.clamp((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime);
        }
        if (wasLit != blockEntity.isLit()) {
            update = true;
            state = (BlockState)state.setValue((Property)CakeOvenBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.setBlockAndUpdate(pos, state);
        }
        if (update) {
            CakeOvenBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean hasResultSpace(RegistryAccess access, @Nullable RecipeHolder<CakeOvenRecipe> holder, boolean hasIngredient, int maxStackSize) {
        if (hasIngredient && holder != null) {
            ItemStack stack = ((CakeOvenRecipe)holder.value()).getResultItem((HolderLookup.Provider)access);
            if (stack.isEmpty()) {
                return false;
            }
            return CakeOvenBlockEntity.canAddToStack(stack, (ItemStack)this.items.get(5), maxStackSize, stack.getCount());
        }
        return false;
    }

    public static boolean canAddToStack(ItemStack stack, ItemStack currentStack, int maxStackSize, int growSize) {
        if (currentStack.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)stack)) {
            return false;
        }
        int combinedCount = currentStack.getCount() + growSize;
        if (combinedCount <= maxStackSize && combinedCount <= currentStack.getMaxStackSize()) {
            return true;
        }
        return combinedCount <= stack.getMaxStackSize();
    }

    private boolean smeltRecipe(RegistryAccess access, @Nullable RecipeHolder<CakeOvenRecipe> holder, boolean hasIngredient, int maxStackSize) {
        if (this.hasResultSpace(access, holder, hasIngredient, maxStackSize)) {
            CakeOvenRecipe recipe = (CakeOvenRecipe)holder.value();
            ItemStack resultStack = (ItemStack)this.items.get(5);
            ItemStack stack = recipe.assemble(new ContainerRecipeInput((Container)this), (HolderLookup.Provider)access);
            if (resultStack.isEmpty()) {
                this.items.set(5, (Object)stack.copy());
            } else if (resultStack.is(stack.getItem())) {
                resultStack.grow(stack.getCount());
            }
            recipe.consumeIngredients((Container)this, this.remainingItems);
            return true;
        }
        return false;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slotIndex) {
        return (ItemStack)this.items.get(slotIndex);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public void setItem(int slotIndex, ItemStack stack) {
        ItemStack currentStack = (ItemStack)this.items.get(slotIndex);
        boolean isSameStack = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentStack);
        this.items.set(slotIndex, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (slotIndex >= 0 && slotIndex <= 3 && !isSameStack) {
            this.cookingTotalTime = CakeOvenBlockEntity.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    private static int getTotalCookTime(Level level, CakeOvenBlockEntity blockEntity) {
        return blockEntity.quickCheck.getRecipeFor((RecipeInput)new ContainerRecipeInput((Container)blockEntity), level).map(holder -> ((CakeOvenRecipe)holder.value()).getCookingTime()).orElse(200);
    }

    public boolean canPlaceItem(int slotIndex, ItemStack stack) {
        if (slotIndex == 5) {
            return false;
        }
        if (slotIndex != 4) {
            return true;
        }
        return Services.HOOKS.getBurnTime(stack) > 0;
    }

    public void clearContent() {
        this.items.clear();
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        this.remainingItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag.getCompound("RemainingItems"), this.remainingItems, (HolderLookup.Provider)provider);
        this.litTime = tag.getShort("BurnTime");
        this.cookingProgress = tag.getShort("CookTime");
        this.cookingTotalTime = tag.getShort("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(4));
        CompoundTag usedRecipes = tag.getCompound("RecipesUsed");
        for (String recipeId : usedRecipes.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)recipeId), usedRecipes.getInt(recipeId));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putShort("BurnTime", (short)this.litTime);
        tag.putShort("CookTime", (short)this.cookingProgress);
        tag.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        CompoundTag remainingItemsTag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)remainingItemsTag, this.remainingItems, (HolderLookup.Provider)provider);
        tag.put("RemainingItems", (Tag)remainingItemsTag);
        CompoundTag usedRecipes = new CompoundTag();
        this.recipesUsed.forEach((id, par1) -> usedRecipes.putInt(id.toString(), par1.intValue()));
        tag.put("RecipesUsed", (Tag)usedRecipes);
    }

    private int getBurnDuration(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        return Services.HOOKS.getBurnTime(stack);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> holder) {
        if (holder != null) {
            this.recipesUsed.addTo((Object)holder.id(), 1);
        }
    }

    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> stacks) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<RecipeHolder<?>> recipeHolders = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        player.awardRecipes(recipeHolders);
        for (RecipeHolder<?> holder : recipeHolders) {
            if (holder == null) continue;
            player.triggerRecipeCrafted(holder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 pos) {
        ArrayList recipeHolders = new ArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(holder -> {
                recipeHolders.add((RecipeHolder<?>)holder);
                AbstractFurnaceBlockEntity.createExperience((ServerLevel)level, (Vec3)pos, (int)entry.getIntValue(), (float)((CakeOvenRecipe)holder.value()).getExperience());
            });
        }
        return recipeHolders;
    }

    public void dropRemainingItems(Level level, BlockPos pos) {
        Containers.dropContents((Level)level, (BlockPos)pos, this.remainingItems);
        this.remainingItems.clear();
    }

    public int[] getSlotsForFace(Direction faceDirection) {
        if (faceDirection == Direction.DOWN) {
            return HOPPER_PULL_SLOTS;
        }
        if (faceDirection == Direction.UP) {
            return HOPPER_FEED_THROUGH_TOP_SLOTS;
        }
        return HOPPER_FEED_THROUGH_SIDE_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slotIndex, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(slotIndex, stack);
    }

    public boolean canTakeItemThroughFace(int slotIndex, ItemStack stack, Direction direction) {
        return true;
    }

    public void fillStackedContents(StackedContents contents) {
        for (ItemStack stack : this.items) {
            contents.accountStack(stack);
        }
    }

    @Override
    public void writeMenuData(ServerPlayer player, FriendlyByteBuf buf) {
    }

    public NonNullList<ItemStack> getRemainingItems() {
        return this.remainingItems;
    }
}

