/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.cake.candle;

import com.google.common.collect.ImmutableList;
import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.BaseThreeTieredCakeBlock;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.util.CakeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BaseThreeTieredCandleCakeBlock
extends BaseCandleCakeBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    protected static final VoxelShape UPPER_SHAPE = Shapes.or((VoxelShape)BaseThreeTieredCandleCakeBlock.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (VoxelShape)BaseThreeTieredCandleCakeBlock.box((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0));
    protected static final VoxelShape LOWER_SHAPE = Shapes.or((VoxelShape)BaseThreeTieredCandleCakeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)BaseThreeTieredCandleCakeBlock.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0));

    public BaseThreeTieredCandleCakeBlock(BaseCakeBlock parentCake, Block candle, BlockBehaviour.Properties properties) {
        super(parentCake, candle, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? LOWER_SHAPE : UPPER_SHAPE;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return CakeUtil.redirectUse((Block)this, state, level, pos, (aboveState, abovePos) -> aboveState.useItemOn(stack, level, player, hand, hitResult.withPosition(abovePos)), () -> super.useItemOn(stack, state, level, pos, player, hand, hitResult));
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return CakeUtil.redirectUse((Block)this, state, level, pos, (aboveState, abovePos) -> aboveState.useWithoutItem(level, player, hitResult.withPosition(abovePos)), () -> super.useWithoutItem(state, level, pos, player, hitResult));
    }

    @Override
    protected void afterEaten(BlockState state, BlockPos pos, Level level, Player player) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (belowState.is((Block)this) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlockAndUpdate(belowPos, this.createLowerState());
        }
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf blockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (neighborState.is((Block)this) && (blockHalf == DoubleBlockHalf.UPPER && direction == Direction.DOWN || blockHalf == DoubleBlockHalf.LOWER && direction == Direction.UP)) {
            state = (BlockState)state.setValue((Property)LIT, (Comparable)((Boolean)neighborState.getValue((Property)LIT)));
        }
        if (direction.getAxis() != Direction.Axis.Y || blockHalf == DoubleBlockHalf.LOWER != (direction == Direction.UP)) {
            return blockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)accessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
        }
        return neighborState.is((Block)this) && neighborState.getValue(HALF) != blockHalf ? state : (blockHalf == DoubleBlockHalf.LOWER ? this.createLowerState() : Blocks.AIR.defaultBlockState());
    }

    protected BlockState createLowerState() {
        return CakeUtil.createLowerState(this.getParentCake(), true);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide()) {
            CakeUtil.destroyOppositeHalf(state, pos, level, ItemStack.EMPTY, !player.isCreative());
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        level.setBlockAndUpdate(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? super.canSurvive(state, reader, pos) : reader.getBlockState(pos.below()).is((Block)this);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    @Override
    public void spawnCandleFlames(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            super.spawnCandleFlames(state, level, pos, random);
        }
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        this.spawnCandleFlames(state, level, pos, random);
        this.getParentCake().animateTick((BlockState)this.getParentCake().defaultBlockState().setValue(HALF, (Comparable)((DoubleBlockHalf)state.getValue(HALF))), level, pos, random);
    }

    @Override
    protected boolean candleHit(BlockHitResult hitResult, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return super.candleHit(hitResult, state);
        }
        return false;
    }

    @Override
    protected double getCandleHeight() {
        return 0.3125;
    }

    @Override
    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return ImmutableList.of((Object)new Vec3(0.5, 0.8125, 0.5));
    }

    @Override
    public BaseThreeTieredCakeBlock getParentCake() {
        return (BaseThreeTieredCakeBlock)super.getParentCake();
    }
}

