/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.cake.candle;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.util.CakeUtil;
import einstein.jmc.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseCandleCakeBlock
extends AbstractCandleBlock {
    private static final MapCodec<BaseCandleCakeBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Util.blockOfTypeCodec(BaseCakeBlock.class).fieldOf("parent").forGetter(BaseCandleCakeBlock::getParentCake), (App)Util.blockOfTypeCodec(CandleBlock.class).fieldOf("candle").forGetter(BaseCandleCakeBlock::getCandle), (App)BaseCandleCakeBlock.propertiesCodec()).apply((Applicative)instance, BaseCandleCakeBlock::new));
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0));
    private final BaseCakeBlock parentCake;
    private final CandleBlock candle;

    public BaseCandleCakeBlock(BaseCakeBlock parentCake, Block candle, BlockBehaviour.Properties properties) {
        super(properties);
        this.parentCake = parentCake;
        this.candle = (CandleBlock)candle;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.FLINT_AND_STEEL) || stack.is(Items.FIRE_CHARGE)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (this.candleHit(hitResult, state) && stack.isEmpty() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            BaseCandleCakeBlock.extinguish((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        InteractionResult result = this.parentCake.eat(level, pos, this.parentCake.defaultBlockState(), player);
        if (result.consumesAction()) {
            BaseCandleCakeBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            this.afterEaten(state, pos, level, player);
        }
        return result;
    }

    protected void afterEaten(BlockState state, BlockPos pos, Level level, Player player) {
    }

    protected boolean candleHit(BlockHitResult hitResult, BlockState state) {
        return hitResult.getLocation().y - (double)hitResult.getBlockPos().getY() > this.getCandleHeight();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public ItemStack getCloneItemStack(LevelReader reader, BlockPos pos, BlockState state) {
        ItemStack stack = new ItemStack((ItemLike)this.parentCake.asItem());
        if (stack.isEmpty() && this.parentCake.getFamily() != null) {
            return new ItemStack((ItemLike)this.parentCake.getFamily().getBaseCake().get());
        }
        return stack;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)accessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.getBlockState(pos.below()).isSolid();
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return CakeUtil.getComparatorOutput(this.parentCake.defaultBlockState());
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }

    public void spawnCandleFlames(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        this.spawnCandleFlames(state, level, pos, random);
        this.parentCake.animateTick(this.parentCake.defaultBlockState(), level, pos, random);
    }

    protected MapCodec<? extends AbstractCandleBlock> codec() {
        return CODEC;
    }

    protected double getCandleHeight() {
        return 0.5;
    }

    public BaseCakeBlock getParentCake() {
        return this.parentCake;
    }

    public CandleBlock getCandle() {
        return this.candle;
    }
}

