/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.cake;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.registration.family.CakeFamily;
import einstein.jmc.util.CakeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BaseThreeTieredCakeBlock
extends BaseCakeBlock {
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)15);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    protected static final VoxelShape[] SHAPE_BY_BITE_UPPER = new VoxelShape[]{Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)5.0, (double)-1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)7.0, (double)-1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)9.0, (double)-1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)11.0, (double)-1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block()};
    protected static final VoxelShape[] SHAPE_BY_BITE_LOWER = new VoxelShape[]{Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block(), Shapes.or((VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)4.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)6.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)8.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)10.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)4.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public BaseThreeTieredCakeBlock(CakeVariant builder) {
        super(builder, 15);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int bites;
        CakeFamily family;
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER && (family = this.getFamily()) != null && stack.is(family.getBaseCake().get().asItem()) && ((bites = ((Integer)state.getValue((Property)this.getBites())).intValue()) == 5 ? CakeUtil.convertToThreeTiered(family, state, pos, level, player, stack, true).consumesAction() : bites == 10 && CakeUtil.convertToTwoTiered(family, state, pos, level, player, stack, true).consumesAction())) {
            return ItemInteractionResult.SUCCESS;
        }
        return CakeUtil.redirectUse(this, state, level, pos, (aboveState, abovePos) -> aboveState.useItemOn(stack, level, player, hand, hitResult.withPosition(abovePos)), () -> super.useItemOn(stack, state, level, pos, player, hand, hitResult));
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return CakeUtil.redirectUse(this, state, level, pos, (aboveState, abovePos) -> aboveState.useWithoutItem(level, player, hitResult.withPosition(abovePos)), () -> super.useWithoutItem(state, level, pos, player, hitResult));
    }

    @Override
    public void afterCandlePlaced(Level level, BlockState state, BlockPos pos, BaseCandleCakeBlock candleCake) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (belowState.is((Block)this) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlockAndUpdate(belowPos, CakeUtil.createLowerState((Block)candleCake, false));
        }
    }

    @Override
    public InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        InteractionResult result = super.eat(level, pos, state, player);
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (belowState.is((Block)this) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.updateNeighbourForOutputSignal(belowPos, belowState.getBlock());
        }
        return result;
    }

    @Override
    public BlockState eatActions(Player player, BlockPos pos, BlockState state) {
        if ((state = super.eatActions(player, pos, state)).getValue(HALF) == DoubleBlockHalf.UPPER && (Integer)state.getValue((Property)BITES) >= 4) {
            return (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(this.getSlices()));
        }
        return state;
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf blockHalf = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() != Direction.Axis.Y || blockHalf == DoubleBlockHalf.LOWER != (direction == Direction.UP)) {
            return blockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)accessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return neighborState.is((Block)this) ? state : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide()) {
            CakeUtil.destroyOppositeHalf(state, pos, level, ItemStack.EMPTY, !player.isCreative());
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            return CakeUtil.createLowerState(this, true);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? super.canSurvive(state, reader, pos) : reader.getBlockState(pos.below()).is((Block)this);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HALF});
    }

    @Override
    public IntegerProperty getBites() {
        return BITES;
    }

    @Override
    public VoxelShape[] getShapeByBite(BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? SHAPE_BY_BITE_LOWER : SHAPE_BY_BITE_UPPER;
    }

    @Override
    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockPos abovePos = pos.above();
        BlockState aboveState = level.getBlockState(abovePos);
        int slices = this.getSlices() + 1;
        if (aboveState.is((Block)this) && aboveState.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return slices - (Integer)aboveState.getValue((Property)this.getBites());
        }
        return slices - (Integer)state.getValue((Property)this.getBites());
    }
}

