/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.message;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.ProtocolVersion;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.channel.C2SChannel;
import com.misterpemodder.shulkerboxtooltip.impl.network.context.MessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.C2SMessages;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CHandshakeResponse;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CMessages;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public record C2SHandshakeStart(ProtocolVersion clientVersion) {

    public static class Type
    implements MessageType<C2SHandshakeStart> {
        @Override
        public void encode(C2SHandshakeStart message, FriendlyByteBuf buf) {
            message.clientVersion.writeToPacketBuf(buf);
        }

        @Override
        public C2SHandshakeStart decode(FriendlyByteBuf buf) {
            return new C2SHandshakeStart(ProtocolVersion.readFromPacketBuf(buf));
        }

        @Override
        public void onReceive(C2SHandshakeStart message, MessageContext<C2SHandshakeStart> context) {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            C2SChannel channel = (C2SChannel)context.getChannel();
            if (message.clientVersion == null) {
                ShulkerBoxTooltip.LOGGER.error(player.getGameProfile().getName() + ": received invalid handshake packet");
                channel.unregisterFor(player);
                return;
            }
            ShulkerBoxTooltip.LOGGER.info(player.getGameProfile().getName() + ": protocol version: " + String.valueOf(message.clientVersion));
            if (message.clientVersion.major() != ProtocolVersion.CURRENT.major()) {
                ShulkerBoxTooltip.LOGGER.error(player.getGameProfile().getName() + ": incompatible client protocol version, expected " + ProtocolVersion.CURRENT.major() + ", got " + message.clientVersion.major());
                channel.unregisterFor(player);
                return;
            }
            context.execute(() -> {
                S2CMessages.HANDSHAKE_RESPONSE.sendTo(player, new S2CHandshakeResponse(ProtocolVersion.CURRENT, ShulkerBoxTooltip.config));
                ServerNetworking.addClient(player, message.clientVersion);
            });
        }

        @Override
        public void onRegister(MessageContext<C2SHandshakeStart> context) {
            if (context.getReceivingSide() == MessageContext.Side.CLIENT) {
                C2SMessages.attemptHandshake();
            }
        }
    }
}

