/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.manager;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.EnderStoragePlugin;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.api.StorageType;
import codechicken.lib.util.ServerUtils;
import com.google.common.collect.ImmutableMap;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class EnderStorageManager {
    @Nullable
    private static EnderStorageManager serverManager;
    @Nullable
    private static EnderStorageManager clientManager;
    private static Map<StorageType<?>, EnderStoragePlugin<?>> plugins;
    private Map<String, AbstractEnderStorage> storageMap;
    private Map<StorageType<?>, List<AbstractEnderStorage>> storageList;
    public final boolean client;
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private List<AbstractEnderStorage> dirtyStorage;
    private CompoundTag saveTag;

    public EnderStorageManager(boolean client) {
        this.client = client;
        this.storageMap = Collections.synchronizedMap(new HashMap());
        this.storageList = Collections.synchronizedMap(new HashMap());
        this.dirtyStorage = Collections.synchronizedList(new LinkedList());
        for (StorageType<?> key : plugins.keySet()) {
            this.storageList.put(key, new ArrayList());
        }
        if (!client) {
            this.load();
        }
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(EnderStorageManager::onServerStarted);
    }

    private static void onServerStarted(ServerStartedEvent event) {
        EnderStorageManager.reloadManager(false);
    }

    private void sendClientInfo(ServerPlayer player) {
        for (Map.Entry<StorageType<?>, EnderStoragePlugin<?>> plugin : plugins.entrySet()) {
            plugin.getValue().sendClientInfo(player, (List)EnderStorageManager.unsafeCast(this.storageList.get(plugin.getKey())));
        }
    }

    private static <T> T unsafeCast(Object object) {
        return (T)object;
    }

    private void load() {
        this.saveDir = new File(ServerUtils.getSaveDirectory().toFile(), "EnderStorage");
        try {
            if (!this.saveDir.exists()) {
                this.saveDir.mkdirs();
            }
            this.saveFiles = new File[]{new File(this.saveDir, "data1.dat"), new File(this.saveDir, "data2.dat"), new File(this.saveDir, "lock.dat")};
            if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                FileInputStream fin = new FileInputStream(this.saveFiles[2]);
                this.saveTo = fin.read() ^ 1;
                fin.close();
                if (this.saveFiles[this.saveTo ^ 1].exists()) {
                    FileInputStream in = new FileInputStream(this.saveFiles[this.saveTo ^ 1]);
                    this.saveTag = NbtIo.readCompressed((InputStream)in, (NbtAccounter)NbtAccounter.unlimitedHeap());
                    in.close();
                } else {
                    this.saveTag = new CompoundTag();
                }
            } else {
                this.saveTag = new CompoundTag();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("EnderStorage was unable to read it's data, please delete the 'EnderStorage' folder Here: %s and start the server again.", this.saveDir), e);
        }
    }

    private void save(boolean force) {
        if (!this.dirtyStorage.isEmpty() || force) {
            for (AbstractEnderStorage inv : this.dirtyStorage) {
                this.saveTag.put(String.valueOf(inv.freq) + ",type=" + inv.type(), (Tag)inv.saveToTag((HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess()));
                inv.setClean();
            }
            this.dirtyStorage.clear();
            try {
                File saveFile = this.saveFiles[this.saveTo];
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dout = new DataOutputStream(new FileOutputStream(saveFile));
                NbtIo.writeCompressed((CompoundTag)this.saveTag, (OutputStream)dout);
                dout.close();
                FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
                fout.write(this.saveTo);
                fout.close();
                this.saveTo ^= 1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void reloadManager(boolean client) {
        EnderStorageManager newManager = new EnderStorageManager(client);
        if (client) {
            clientManager = newManager;
        } else {
            serverManager = newManager;
        }
    }

    public File getSaveDir() {
        return this.saveDir;
    }

    public static EnderStorageManager instance(boolean client) {
        EnderStorageManager manager;
        EnderStorageManager enderStorageManager = manager = client ? clientManager : serverManager;
        if (manager == null) {
            EnderStorageManager.reloadManager(client);
            manager = client ? clientManager : serverManager;
        }
        return manager;
    }

    public <T extends AbstractEnderStorage> T getStorage(Frequency freq, StorageType<T> type) {
        String key = String.valueOf(freq) + ",type=" + type.name();
        AbstractEnderStorage storage = this.storageMap.get(key);
        if (storage == null) {
            storage = plugins.get(type).createEnderStorage(this, freq);
            if (!this.client && this.saveTag.contains(key)) {
                storage.loadFromTag(this.saveTag.getCompound(key), (HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess());
            }
            this.storageMap.put(key, storage);
            this.storageList.get(type).add(storage);
        }
        return (T)storage;
    }

    public static void registerPlugin(EnderStoragePlugin<?> plugin) {
        plugins.put(plugin.identifier(), plugin);
        if (serverManager != null) {
            EnderStorageManager.serverManager.storageList.put(plugin.identifier(), new ArrayList());
        }
        if (clientManager != null) {
            EnderStorageManager.clientManager.storageList.put(plugin.identifier(), new ArrayList());
        }
    }

    public static EnderStoragePlugin<?> getPlugin(StorageType<?> identifier) {
        return plugins.get(identifier);
    }

    public static Map<StorageType<?>, EnderStoragePlugin<?>> getPlugins() {
        return ImmutableMap.copyOf(plugins);
    }

    public List<String> getValidKeys(String identifer) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.saveTag.getAllKeys()) {
            if (!key.endsWith(",type=" + identifer)) continue;
            list.add(key.replace(",type=" + identifer, ""));
        }
        return list;
    }

    public void requestSave(AbstractEnderStorage storage) {
        this.dirtyStorage.add(storage);
    }

    static {
        plugins = new HashMap();
    }

    public static class EnderStorageSaveHandler {
        @SubscribeEvent
        public void onWorldLoad(LevelEvent.Load event) {
            if (event.getLevel().isClientSide()) {
                EnderStorageManager.reloadManager(true);
            }
        }

        @SubscribeEvent
        public void onWorldSave(LevelEvent.Save event) {
            if (!event.getLevel().isClientSide() && EnderStorageManager.instance(false) != null) {
                EnderStorageManager.instance(false).save(false);
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            EnderStorageManager.instance(false).sendClientInfo((ServerPlayer)event.getEntity());
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            EnderStorageManager.instance(false).sendClientInfo((ServerPlayer)event.getEntity());
        }
    }
}

