/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.datagen.providers;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.zjjohn121110.aethersdelight.registry.AethersDelightItems;
import vectorwing.farmersdelight.data.ItemModels;

public class ADItemModelProvider
extends ItemModelProvider {
    public static final ResourceLocation MUG = ResourceLocation.fromNamespaceAndPath((String)"aethersdelight", (String)"item/mug");
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";

    public ADItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "aethersdelight", existingFileHelper);
    }

    protected void registerModels() {
        Set items = BuiltInRegistries.ITEM.stream().filter(i -> "aethersdelight".equals(BuiltInRegistries.ITEM.getKey(i).getNamespace())).collect(Collectors.toSet());
        this.basicItem((Item)AethersDelightItems.RAW_ARKENIUM.get());
        this.basicItem((Item)AethersDelightItems.ARKENIUM_INGOT.get());
        this.basicItem((Item)AethersDelightItems.ARKENIUM_NUGGET.get());
        this.basicItem((Item)AethersDelightItems.GINGER.get());
        this.basicItem((Item)AethersDelightItems.GINGER_SPICE.get());
        this.basicItem((Item)AethersDelightItems.GINGERBREAD_DOUGH.get());
        this.basicItem((Item)AethersDelightItems.GINGERBREAD.get());
        this.basicItem((Item)AethersDelightItems.GINGERBREAD_MOA.get());
        this.basicItem((Item)AethersDelightItems.GINGERBREAD_STAR.get());
        this.basicItem((Item)AethersDelightItems.GINGERBREAD_MAN_BASE.get());
        this.basicItem((Item)AethersDelightItems.GINGERBREAD_MOA_BASE.get());
        this.basicItem((Item)AethersDelightItems.GINGERBREAD_STAR_BASE.get());
        this.basicItem((Item)AethersDelightItems.PEPPERMINT_LEAF.get());
        this.basicItem((Item)AethersDelightItems.PEPPERMINT_EXTRACT.get());
        this.basicItem((Item)AethersDelightItems.PARSNIP.get());
        this.basicItem((Item)AethersDelightItems.COOKED_PARSNIP.get());
        this.basicItem((Item)AethersDelightItems.LEEK.get());
        this.basicItem((Item)AethersDelightItems.BLUE_BERRY_JAM.get());
        this.basicItem((Item)AethersDelightItems.ENCHANTED_BERRY_JAM.get());
        this.basicItem((Item)AethersDelightItems.BLUE_BERRY_MUFFIN.get());
        this.basicItem((Item)AethersDelightItems.ENCHANTED_BERRY_MUFFIN.get());
        this.basicItem((Item)AethersDelightItems.FRIED_MOA_EGG.get());
        this.basicItem((Item)AethersDelightItems.RAW_MOA.get());
        this.basicItem((Item)AethersDelightItems.COOKED_MOA.get());
        this.basicItem((Item)AethersDelightItems.RAW_MOA_CUTS.get());
        this.basicItem((Item)AethersDelightItems.COOKED_MOA_CUTS.get());
        this.basicItem((Item)AethersDelightItems.WING.get());
        this.basicItem((Item)AethersDelightItems.COOKED_WING.get());
        this.basicItem((Item)AethersDelightItems.WHITE_APPLE_PIE.get());
        this.basicItem((Item)AethersDelightItems.WHITE_APPLE_PIE_SLICE.get());
        this.basicItem((Item)AethersDelightItems.SWET_SOUP.get());
        this.basicItem((Item)AethersDelightItems.GINGER_SOUP.get());
        this.basicItem((Item)AethersDelightItems.MOA_STEW.get());
        this.basicItem((Item)AethersDelightItems.FLYING_BEEF_STEW.get());
        this.basicItem((Item)AethersDelightItems.PARSNIP_PASTA.get());
        this.basicItem((Item)AethersDelightItems.MOA_EGG_OMELETTE.get());
        this.basicItem((Item)AethersDelightItems.PEPPERMINT_CANDY_DOUGH.get());
        this.basicItem((Item)AethersDelightItems.PEPPERMINT_CANDY.get());
        this.basicItem((Item)AethersDelightItems.CANDIED_WHITE_APPLE.get());
        this.basicItem((Item)AethersDelightItems.COOKIE_CUTTER_MAN.get());
        this.basicItem((Item)AethersDelightItems.COOKIE_CUTTER_MOA.get());
        this.basicItem((Item)AethersDelightItems.COOKIE_CUTTER_STAR.get());
        HashSet flatBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)AethersDelightItems.WILD_GINGER.get(), (Item)AethersDelightItems.WILD_LEEK.get(), (Item)AethersDelightItems.WILD_PARSNIP.get()});
        ItemModels.takeAll(items, (Object[])flatBlockItems.toArray(new Item[0])).forEach(item -> this.itemGeneratedModel((Item)item, this.resourceBlock(this.itemName((Item)item))));
        HashSet handheldItems = Sets.newHashSet((Object[])new Item[]{(Item)AethersDelightItems.HOLYSTONE_KNIFE.get(), (Item)AethersDelightItems.ZANITE_KNIFE.get(), (Item)AethersDelightItems.ARKENIUM_KNIFE.get(), (Item)AethersDelightItems.GRAVITITE_KNIFE.get()});
        ItemModels.takeAll(items, (Object[])handheldItems.toArray(new Item[0])).forEach(item -> this.itemHandheldModel((Item)item, this.resourceItem(this.itemName((Item)item))));
        this.basicItem((Item)AethersDelightItems.AECHOR_ICE_CREAM_BUCKET_BLOCK.get());
        this.basicItem((Item)AethersDelightItems.AECHOR_ICE_CREAM.get());
        this.basicItem((Item)AethersDelightItems.AECHOR_ICE_CREAM_BASE.get());
        this.basicItem((Item)AethersDelightItems.ROAST_MOA_BLOCK.get());
        this.basicItem((Item)AethersDelightItems.ROAST_MOA.get());
        HashSet mugItems = Sets.newHashSet((Object[])new Item[]{(Item)AethersDelightItems.GINGER_ALE.get(), (Item)AethersDelightItems.PEPPERMINT_TEA.get()});
        ItemModels.takeAll(items, (Object[])mugItems.toArray(new Item[0])).forEach(item -> this.itemMugModel((Item)item, this.resourceItem(this.itemName((Item)item))));
    }

    public void itemHandheldModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), HANDHELD)).texture("layer0", texture);
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", texture);
    }

    public void itemMugModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), MUG)).texture("layer0", texture);
    }

    private String itemName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    public ResourceLocation resourceItem(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"aethersdelight", (String)("item/" + path));
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"aethersdelight", (String)("block/" + path));
    }
}

