/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.zjjohn121110.aethersdelight.block.AetherCabinetBlock;
import net.zjjohn121110.aethersdelight.block.entity.AethersDelightBlockEntity;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class AetherCabinetBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> contents = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            AetherCabinetBlockEntity.this.playSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_OPEN.get());
            AetherCabinetBlockEntity.this.updateBlockState(state, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            AetherCabinetBlockEntity.this.playSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_CLOSE.get());
            AetherCabinetBlockEntity.this.updateBlockState(state, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState sta, int arg1, int arg2) {
        }

        protected boolean isOwnContainer(Player p_155060_) {
            if (p_155060_.containerMenu instanceof ChestMenu) {
                Container container = ((ChestMenu)p_155060_.containerMenu).getContainer();
                return container == AetherCabinetBlockEntity.this;
            }
            return false;
        }
    };

    public AetherCabinetBlockEntity(BlockPos pos, BlockState state) {
        super(AethersDelightBlockEntity.CABINET.get(), pos, state);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.contents, (HolderLookup.Provider)registries);
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.contents = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(compound)) {
            ContainerHelper.loadAllItems((CompoundTag)compound, this.contents, (HolderLookup.Provider)registries);
        }
    }

    public int getContainerSize() {
        return 27;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.contents;
    }

    protected void setItems(NonNullList<ItemStack> itemsIn) {
        this.contents = itemsIn;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.aethersdelight.drawer");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return ChestMenu.threeRows((int)id, (Inventory)player, (Container)this);
    }

    public void startOpen(Player pPlayer) {
        if (this.level != null && !this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (this.level != null && !this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (this.level != null && !this.remove) {
            this.openersCounter.recheckOpeners(this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    void updateBlockState(BlockState state, boolean open) {
        if (this.level != null) {
            this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)AetherCabinetBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void playSound(BlockState state, SoundEvent sound) {
        if (this.level == null) {
            return;
        }
        Vec3i drawerFacingVector = ((Direction)state.getValue((Property)AetherCabinetBlock.FACING)).getNormal();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)drawerFacingVector.getX() / 2.0;
        double y = (double)this.worldPosition.getY() + 0.5 + (double)drawerFacingVector.getY() / 2.0;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)drawerFacingVector.getZ() / 2.0;
        this.level.playSound(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }
}

