/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight.block;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.natural.AetherBushBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.zjjohn121110.aethersdelight.registry.AethersDelightBlocks;

public class PeppermintBushStemBlock
extends AetherBushBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public PeppermintBushStemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)AetherConfig.SERVER.berry_bush_consistency.get()).booleanValue() && entity instanceof LivingEntity && entity.getType() != EntityType.FOX && entity.getType() != EntityType.BEE) {
            entity.makeStuckInBlock(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(60) == 0 ? 1 : 0) != 0)) {
            level.setBlockAndUpdate(pos, (BlockState)((Block)AethersDelightBlocks.PEPPERMINT_BUSH_STEM.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)((Boolean)state.getValue((Property)AetherBlockStateProperties.DOUBLE_DROPS))));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlockAndUpdate(pos, (BlockState)((Block)AethersDelightBlocks.PEPPERMINT_BUSH.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)((Boolean)state.getValue((Property)AetherBlockStateProperties.DOUBLE_DROPS))));
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.nextFloat() <= 0.45;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

