/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.protect_your_moa.network.packet.clientbound;

import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.protect_your_moa.client.MoaArmorClient;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenMoaInventoryPacket(int entityId, int containerSize, int containerId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenMoaInventoryPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether_protect_your_moa", (String)"open_moa_inventory"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenMoaInventoryPacket> STREAM_CODEC = CustomPacketPayload.codec(OpenMoaInventoryPacket::write, OpenMoaInventoryPacket::decode);

    public CustomPacketPayload.Type<OpenMoaInventoryPacket> type() {
        return TYPE;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entityId());
        buf.writeVarInt(this.containerSize());
        buf.writeByte(this.containerId());
    }

    public static OpenMoaInventoryPacket decode(RegistryFriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int containerSize = buf.readVarInt();
        short containerId = buf.readUnsignedByte();
        return new OpenMoaInventoryPacket(entityId, containerSize, containerId);
    }

    public static void execute(OpenMoaInventoryPacket payload, IPayloadContext context) {
        Entity entity;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().player.level().getEntity(payload.entityId())) instanceof Moa) {
            Moa moa = (Moa)entity;
            MoaArmorClient.setToMoaInventoryScreen(Minecraft.getInstance().player, moa, payload.containerSize(), payload.containerId());
        }
    }
}

