/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.protect_your_moa.event.hooks;

import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import com.aetherteam.protect_your_moa.attachment.MoaArmorAttachment;
import com.aetherteam.protect_your_moa.attachment.ProtectDataAttachments;
import com.aetherteam.protect_your_moa.client.ProtectSoundEvents;
import com.aetherteam.protect_your_moa.item.combat.MoaArmorItem;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class EntityHooks {
    public static Optional<InteractionResult> interactionOpenMoaInventory(Entity target, Player player) {
        Moa moa;
        if (target instanceof Moa && (moa = (Moa)target).isPlayerGrown() && !moa.isBaby() && player.isShiftKeyDown() && player.getMainHandItem().isEmpty()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).openInventory(serverPlayer, moa);
            }
            return Optional.of(InteractionResult.sidedSuccess((boolean)player.level().isClientSide()));
        }
        return Optional.empty();
    }

    public static Optional<InteractionResult> equipMoaArmor(Entity target, Player player, ItemStack stack) {
        Moa moa;
        if (target instanceof Moa && (moa = (Moa)target).isPlayerGrown() && !moa.isBaby() && !moa.isVehicle() && !stack.isEmpty() && stack.getItem() instanceof MoaArmorItem && ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).isArmor(stack) && !player.isSecondaryUseActive() && !((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).isWearingArmor()) {
            if (!player.level().isClientSide()) {
                ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).setSynched(moa.getId(), INBTSynchable.Direction.CLIENT, "equipArmor", stack);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                return Optional.of(InteractionResult.CONSUME);
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }

    public static Optional<InteractionResult> equipMoaChest(Entity target, Player player, ItemStack stack) {
        Moa moa;
        if (target instanceof Moa && (moa = (Moa)target).isPlayerGrown() && !moa.isBaby() && !moa.isVehicle() && !stack.isEmpty() && stack.is(Items.CHEST) && !player.isSecondaryUseActive() && !((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).hasChest()) {
            if (!player.level().isClientSide()) {
                ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).setSynched(moa.getId(), INBTSynchable.Direction.CLIENT, "setChest", true);
                moa.playSound((SoundEvent)ProtectSoundEvents.ENTITY_MOA_CHEST.get(), 1.0f, (moa.getRandom().nextFloat() - moa.getRandom().nextFloat()) * 0.2f + 1.0f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).createInventory();
                return Optional.of(InteractionResult.CONSUME);
            }
            return Optional.of(InteractionResult.SUCCESS);
        }
        return Optional.empty();
    }

    public static void onJoinLevel(Entity entity) {
        if (entity instanceof Moa) {
            Moa moa = (Moa)entity;
            ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).onJoinLevel();
        }
    }

    public static void onUpdate(Entity entity) {
        if (entity instanceof Moa) {
            Moa moa = (Moa)entity;
            ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).onUpdate();
        }
    }

    public static void onDrops(Entity entity, Collection<ItemEntity> drops) {
        if (entity instanceof Moa) {
            Moa moa = (Moa)entity;
            SimpleContainer inventory = ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).getInventory();
            if (((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).hasChest()) {
                if (!moa.level().isClientSide()) {
                    ItemEntity itemEntity2 = new ItemEntity(moa.level(), moa.getX(), moa.getY() + 0.0, moa.getZ(), new ItemStack((ItemLike)Blocks.CHEST));
                    itemEntity2.setDefaultPickUpDelay();
                    drops.add(itemEntity2);
                }
                ((MoaArmorAttachment)moa.getData(ProtectDataAttachments.MOA_ARMOR)).setChest(false);
            }
            if (inventory != null) {
                drops.removeIf(itemEntity -> itemEntity.getItem().is(Items.SADDLE));
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    ItemStack itemStack = inventory.getItem(i);
                    if (itemStack.isEmpty() || itemStack.getEnchantmentLevel(entity.level().holderOrThrow(Enchantments.VANISHING_CURSE)) != 0) continue;
                    ItemEntity itemEntity3 = new ItemEntity(moa.level(), moa.getX(), moa.getY() + 0.0, moa.getZ(), itemStack);
                    itemEntity3.setDefaultPickUpDelay();
                    drops.add(itemEntity3);
                }
            }
        }
    }
}

