/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.protect_your_moa.attachment;

import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import com.aetherteam.nitrogen.network.packet.SyncPacket;
import com.aetherteam.protect_your_moa.inventory.menu.MoaInventoryMenu;
import com.aetherteam.protect_your_moa.item.combat.MoaArmorItem;
import com.aetherteam.protect_your_moa.mixin.mixins.common.accessor.ServerPlayerAccessor;
import com.aetherteam.protect_your_moa.network.packet.MoaArmorSyncPacket;
import com.aetherteam.protect_your_moa.network.packet.clientbound.OpenMoaInventoryPacket;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Triple;

public class MoaArmorAttachment
implements INBTSynchable,
INBTSerializable<CompoundTag>,
ContainerListener {
    private static final ResourceLocation ARMOR_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"aether_protect_your_moa", (String)"moa_armor_modifier");
    private final Moa moa;
    private boolean chested;
    private SimpleContainer inventory;
    private boolean shouldSyncChest;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("equipSaddle", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.equipSaddle(), this::isSaddled)), Map.entry("equipArmor", Triple.of((Object)INBTSynchable.Type.ITEM_STACK, object -> this.equipArmor((ItemStack)object), this::getArmor)), Map.entry("setChest", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setChest((Boolean)object), this::hasChest)), Map.entry("setShouldSyncChest", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setShouldSyncChest((Boolean)object), this::shouldSyncChest)));

    public MoaArmorAttachment(Moa moa) {
        this.moa = moa;
        this.createInventory();
    }

    public Moa getMoa() {
        return this.moa;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (!this.getInventory().getItem(0).isEmpty()) {
            tag.put("SaddleItem", this.inventory.getItem(0).save(provider, (Tag)new CompoundTag()));
        }
        if (!this.getInventory().getItem(1).isEmpty()) {
            tag.put("ArmorItem", this.inventory.getItem(1).save(provider, (Tag)new CompoundTag()));
        }
        tag.putBoolean("Chested", this.hasChest());
        if (this.hasChest()) {
            ListTag list = new ListTag();
            for (int i = 2; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                CompoundTag slotTag = new CompoundTag();
                slotTag.putByte("Slot", (byte)i);
                list.add((Object)itemstack.save(provider, (Tag)slotTag));
            }
            tag.put("Items", (Tag)list);
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        ItemStack itemstack;
        ItemStack itemStack;
        if (tag.contains("SaddleItem", 10) && (itemStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("SaddleItem"))).is(Items.SADDLE)) {
            this.getInventory().setItem(0, itemStack);
        }
        if (tag.contains("ArmorItem", 10) && !(itemstack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("ArmorItem"))).isEmpty() && this.isArmor(itemstack)) {
            this.getInventory().setItem(1, itemstack);
        }
        this.setChest(tag.getBoolean("Chested"));
        if (this.hasChest()) {
            ListTag list = tag.getList("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compoundtag = list.getCompound(i);
                int j = compoundtag.getByte("Slot") & 0xFF;
                if (j < 2 || j >= this.inventory.getContainerSize()) continue;
                this.inventory.setItem(j, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundtag));
            }
        }
        this.updateContainerEquipment();
    }

    public void onJoinLevel() {
        if (this.getMoa().level().isClientSide()) {
            this.setSynched(this.getMoa().getId(), INBTSynchable.Direction.SERVER, "setShouldSyncChest", true);
        }
    }

    public void onUpdate() {
        this.tickArmor();
        this.syncChest();
    }

    private void tickArmor() {
        Item item = this.getArmor().getItem();
        if (item instanceof MoaArmorItem) {
            MoaArmorItem moaArmorItem = (MoaArmorItem)item;
            moaArmorItem.tick(this.getMoa(), this.getArmor());
        }
    }

    private void syncChest() {
        if (!this.getMoa().level().isClientSide() && this.shouldSyncChest()) {
            this.setSynched(this.getMoa().getId(), INBTSynchable.Direction.CLIENT, "setChest", this.hasChest());
            this.setShouldSyncChest(false);
        }
    }

    public void containerChanged(Container container) {
        ItemStack oldArmorStack = this.getArmor();
        boolean oldSaddled = this.isSaddled();
        this.updateContainerEquipment();
        if (this.getMoa().tickCount > 20 && !oldSaddled && this.isSaddled()) {
            this.getMoa().playSound(this.getMoa().getSaddleSoundEvent(), 0.5f, 1.0f);
        }
        ItemStack newArmorStack = this.getArmor();
        if (this.getMoa().tickCount > 20 && this.isArmor(newArmorStack) && oldArmorStack != newArmorStack) {
            this.getMoa().playSound(SoundEvents.HORSE_ARMOR, 0.5f, 1.0f);
        }
    }

    private void updateContainerEquipment() {
        if (!this.getMoa().level().isClientSide()) {
            this.getMoa().setSaddled(!this.getInventory().getItem(0).isEmpty());
            this.setArmorEquipment(this.inventory.getItem(1));
            this.getMoa().setDropChance(EquipmentSlot.CHEST, 0.0f);
        }
    }

    private void setArmorEquipment(ItemStack stack) {
        AttributeInstance armorAttribute;
        this.setArmor(stack);
        if (!this.getMoa().level().isClientSide() && (armorAttribute = this.getMoa().getAttribute(Attributes.ARMOR)) != null) {
            int protection;
            armorAttribute.removeModifier(ARMOR_MODIFIER_ID);
            if (this.isArmor(stack) && (protection = ((MoaArmorItem)stack.getItem()).getProtection()) != 0) {
                armorAttribute.addTransientModifier(new AttributeModifier(ARMOR_MODIFIER_ID, (double)protection, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    public void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.removeListener((ContainerListener)this);
            int i = Math.min(simplecontainer.getContainerSize(), this.inventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(j, itemstack.copy());
            }
        }
        this.inventory.addListener((ContainerListener)this);
    }

    public void openInventory(ServerPlayer serverPlayer, Moa moa) {
        if (serverPlayer.containerMenu != serverPlayer.inventoryMenu) {
            serverPlayer.closeContainer();
        }
        ((ServerPlayerAccessor)serverPlayer).callNextContainerCounter();
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenMoaInventoryPacket(moa.getId(), this.inventory.getContainerSize(), ((ServerPlayerAccessor)serverPlayer).protect_your_moa$getContainerCounter()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        serverPlayer.containerMenu = new MoaInventoryMenu(((ServerPlayerAccessor)serverPlayer).protect_your_moa$getContainerCounter(), serverPlayer.getInventory(), (Container)this.inventory, moa);
        ((ServerPlayerAccessor)serverPlayer).callInitMenu(serverPlayer.containerMenu);
        NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)serverPlayer, serverPlayer.containerMenu));
    }

    public void equipSaddle() {
        this.getInventory().setItem(0, new ItemStack((ItemLike)Items.SADDLE));
    }

    public boolean isSaddled() {
        return this.getMoa().isSaddled();
    }

    public void equipArmor(ItemStack armor) {
        this.getInventory().setItem(1, armor.copyWithCount(1));
    }

    public void setArmor(ItemStack itemStack) {
        this.getMoa().setItemSlot(EquipmentSlot.CHEST, itemStack);
        this.getMoa().setDropChance(EquipmentSlot.CHEST, 0.0f);
    }

    public ItemStack getArmor() {
        return this.getMoa().getItemBySlot(EquipmentSlot.CHEST);
    }

    public boolean isWearingArmor() {
        return !this.getMoa().getItemBySlot(EquipmentSlot.CHEST).isEmpty();
    }

    public void setChest(boolean chested) {
        this.chested = chested;
        this.createInventory();
    }

    public boolean hasChest() {
        return this.chested;
    }

    public void setShouldSyncChest(boolean sync) {
        this.shouldSyncChest = sync;
    }

    public boolean shouldSyncChest() {
        return this.shouldSyncChest;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    protected int getInventorySize() {
        return this.hasChest() ? 17 : 2;
    }

    public boolean isArmor(ItemStack stack) {
        return stack.getItem() instanceof MoaArmorItem;
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    public SyncPacket getSyncPacket(int entityID, String key, INBTSynchable.Type type, Object value) {
        return new MoaArmorSyncPacket(entityID, key, type, value);
    }
}

